/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.google.common.collect.ImmutableList;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadBitmapCommand
extends SuspendContextCommandImpl {
    private static final String BITMAP_FQCN = "android.graphics.Bitmap";
    private static final String BITMAP_DRAWABLE_FQCN = "android.graphics.drawable.BitmapDrawable";
    private static final int MAX_DIMENSION = 1024;
    private final Value myBitmapValue;
    private final DebuggerContextImpl myDebuggerContext;
    private final ProgressWindowWithNotification myProgressWindow;
    private final CompletionCallback myCallback;

    public static boolean isSupportedBitmap(Value value) {
        String fqcn = value.type().name();
        return BITMAP_FQCN.equals(fqcn) || BITMAP_DRAWABLE_FQCN.equals(fqcn);
    }

    public DownloadBitmapCommand(@NotNull Value bitmapValue, @NotNull DebuggerContextImpl debuggerContext, @NotNull CompletionCallback callback, @NotNull ProgressWindowWithNotification progressWindow) {
        if (bitmapValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmapValue", "com/android/tools/idea/run/DownloadBitmapCommand", "<init>"));
        }
        if (debuggerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/android/tools/idea/run/DownloadBitmapCommand", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/run/DownloadBitmapCommand", "<init>"));
        }
        if (progressWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressWindow", "com/android/tools/idea/run/DownloadBitmapCommand", "<init>"));
        }
        super(debuggerContext.getSuspendContext());
        this.myBitmapValue = bitmapValue;
        this.myDebuggerContext = debuggerContext;
        this.myCallback = callback;
        this.myProgressWindow = progressWindow;
    }

    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    public void contextAction() throws Exception {
        List<Value> pixelValues;
        this.myProgressWindow.setText("Examining bitmap");
        Value bitmap = this.myBitmapValue;
        EvaluationContextImpl evaluationContext = this.myDebuggerContext.createEvaluationContext();
        String fqcn = bitmap.type().name();
        if (BITMAP_DRAWABLE_FQCN.equals(fqcn) && (bitmap = DownloadBitmapCommand.getBitmapFromDrawable(evaluationContext, (ObjectReference)bitmap)) == null) {
            this.myCallback.error("Unable to obtain bitmap from drawable");
            return;
        }
        String config = DownloadBitmapCommand.getBitmapConfigName((ObjectReference)bitmap, evaluationContext);
        if (!"\"ARGB_8888\"".equals(config)) {
            this.myCallback.error("Unsupported bitmap configuration: " + config);
            return;
        }
        Dimension size = DownloadBitmapCommand.getDimension(evaluationContext, bitmap);
        if (size == null) {
            this.myCallback.error("Unable to determine image dimensions.");
            return;
        }
        if (size.width > 1024 || size.height > 1024) {
            this.myProgressWindow.setText("Scaling down bitmap");
            bitmap = DownloadBitmapCommand.createScaledBitmap(evaluationContext, (ObjectReference)bitmap, size);
            if (bitmap == null) {
                this.myCallback.error("Unable to create scaled bitmap");
                return;
            }
            size = DownloadBitmapCommand.getDimension(evaluationContext, bitmap);
            if (size == null) {
                this.myCallback.error("Unable to obtained scaled bitmap's dimensions");
                return;
            }
        }
        if (this.myProgressWindow.isCanceled()) {
            return;
        }
        this.myProgressWindow.setText("Retrieving pixel data");
        Field bufferField = ((ObjectReference)bitmap).referenceType().fieldByName("mBuffer");
        if (bufferField != null) {
            Value bufferValue = ((ObjectReference)bitmap).getValue(bufferField);
            if (!(bufferValue instanceof ArrayReference)) {
                return;
            }
            pixelValues = ((ArrayReference)bufferValue).getValues();
        } else {
            pixelValues = DownloadBitmapCommand.copyToBuffer(evaluationContext, (ObjectReference)bitmap, size);
            if (pixelValues == null) {
                this.myCallback.error("Unable to extract image data: Bitmap has no buffer field.");
                return;
            }
        }
        byte[] argb = new byte[pixelValues.size()];
        for (int i = 0; i < pixelValues.size(); ++i) {
            Value pixelValue = pixelValues.get(i);
            if (!(pixelValue instanceof ByteValue)) continue;
            argb[i] = ((ByteValue)pixelValue).byteValue();
        }
        if (this.myProgressWindow.isCanceled()) {
            return;
        }
        this.myCallback.bitmapDownloaded(DownloadBitmapCommand.createBufferedImage(size.width, size.height, argb));
    }

    @Nullable
    private static String getBitmapConfigName(ObjectReference bitmap, EvaluationContextImpl evaluationContext) throws EvaluateException {
        Value config = DownloadBitmapCommand.getBitmapConfig(evaluationContext, bitmap);
        if (!(config instanceof ObjectReference)) {
            return null;
        }
        Field f = ((ObjectReference)config).referenceType().fieldByName("name");
        if (f == null) {
            return null;
        }
        return ((ObjectReference)config).getValue(f).toString();
    }

    @Nullable
    private static List<Value> copyToBuffer(EvaluationContextImpl evaluationContext, ObjectReference bitmap, Dimension size) throws EvaluateException {
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        List classes = virtualMachineProxy.classesByName("byte[]");
        if (classes.size() != 1 || !(classes.get(0) instanceof ArrayType)) {
            return null;
        }
        ArrayType byteArrayType = (ArrayType)classes.get(0);
        classes = virtualMachineProxy.classesByName("java.nio.ByteBuffer");
        if (classes.size() != 1 || !(classes.get(0) instanceof ClassType)) {
            return null;
        }
        ClassType byteBufferType = (ClassType)classes.get(0);
        Method wrapMethod = DebuggerUtils.findMethod((ReferenceType)byteBufferType, (String)"wrap", (String)"([B)Ljava/nio/ByteBuffer;");
        if (wrapMethod == null) {
            return null;
        }
        ArrayReference byteArray = byteArrayType.newInstance(size.width * size.height * 4);
        Value byteBufferRef = debugProcess.invokeMethod((EvaluationContext)evaluationContext, byteBufferType, wrapMethod, (List)ImmutableList.of((Object)byteArray));
        Method copyToBufferMethod = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"copyPixelsToBuffer", (String)"(Ljava/nio/Buffer;)V");
        if (copyToBufferMethod == null) {
            return null;
        }
        debugProcess.invokeMethod((EvaluationContext)evaluationContext, bitmap, copyToBufferMethod, (List)ImmutableList.of((Object)byteBufferRef));
        return byteArray.getValues();
    }

    @Nullable
    private static Dimension getDimension(@NotNull EvaluationContextImpl context, @NotNull Value bitmap) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/DownloadBitmapCommand", "getDimension"));
        }
        if (bitmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmap", "com/android/tools/idea/run/DownloadBitmapCommand", "getDimension"));
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Integer w = DownloadBitmapCommand.getImageDimension(context, (ObjectReference)bitmap, debugProcess, "getWidth");
        Integer h = DownloadBitmapCommand.getImageDimension(context, (ObjectReference)bitmap, debugProcess, "getHeight");
        return w != null & h != null ? new Dimension(w, h) : null;
    }

    @Nullable
    private static Value getBitmapConfig(EvaluationContextImpl context, ObjectReference bitmap) throws EvaluateException {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Method getConfig = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"getConfig", (String)"()Landroid/graphics/Bitmap$Config;");
        if (getConfig == null) {
            return null;
        }
        return debugProcess.invokeMethod((EvaluationContext)context, bitmap, getConfig, Collections.emptyList());
    }

    @Nullable
    private static Value getBitmapFromDrawable(@NotNull EvaluationContextImpl context, @NotNull ObjectReference bitmap) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/DownloadBitmapCommand", "getBitmapFromDrawable"));
        }
        if (bitmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmap", "com/android/tools/idea/run/DownloadBitmapCommand", "getBitmapFromDrawable"));
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Method getBitmapMethod = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"getBitmap", (String)"()Landroid/graphics/Bitmap;");
        if (getBitmapMethod == null) {
            return null;
        }
        return debugProcess.invokeMethod((EvaluationContext)context, bitmap, getBitmapMethod, Collections.emptyList());
    }

    @Nullable
    private static Value createScaledBitmap(@NotNull EvaluationContextImpl context, @NotNull ObjectReference bitmap, @NotNull Dimension currentDimensions) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/DownloadBitmapCommand", "createScaledBitmap"));
        }
        if (bitmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmap", "com/android/tools/idea/run/DownloadBitmapCommand", "createScaledBitmap"));
        }
        if (currentDimensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDimensions", "com/android/tools/idea/run/DownloadBitmapCommand", "createScaledBitmap"));
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Method createScaledBitmapMethod = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"createScaledBitmap", (String)"(Landroid/graphics/Bitmap;IIZ)Landroid/graphics/Bitmap;");
        if (createScaledBitmapMethod == null) {
            return null;
        }
        double s = Math.max(currentDimensions.getHeight(), currentDimensions.getWidth()) / 1024.0;
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        Value dstWidth = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getWidth() / s)));
        Value dstHeight = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getHeight() / s)));
        Value filter = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"boolean", (boolean)Boolean.FALSE);
        return debugProcess.invokeMethod((EvaluationContext)context, bitmap, createScaledBitmapMethod, Arrays.asList(bitmap, dstWidth, dstHeight, filter));
    }

    @Nullable
    private static Integer getImageDimension(EvaluationContextImpl context, ObjectReference bitmap, DebugProcessImpl debugProcess, String methodName) throws EvaluateException {
        Value widthValue;
        Method method = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)methodName, (String)"()I");
        if (method != null && (widthValue = debugProcess.invokeMethod((EvaluationContext)context, bitmap, method, Collections.emptyList())) instanceof IntegerValue) {
            return ((IntegerValue)widthValue).value();
        }
        return null;
    }

    private static BufferedImage createBufferedImage(int width, int height, byte[] rgba) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (y * width + x) * 4;
                long rgb = 0L;
                rgb |= ((long)rgba[i + 0] & 0xFFL) << 16;
                rgb |= ((long)rgba[i + 1] & 0xFFL) << 8;
                rgb |= ((long)rgba[i + 2] & 0xFFL) << 0;
                bufferedImage.setRGB(x, y, (int)((rgb |= ((long)rgba[i + 3] & 0xFFL) << 24) & 0xFFFFFFFFFFFFFFFFL));
            }
        }
        return bufferedImage;
    }

    public static interface CompletionCallback {
        public void bitmapDownloaded(@NotNull BufferedImage var1);

        public void error(@NotNull String var1);
    }
}

