/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.multi.RenderPreview;
import com.intellij.openapi.util.Pair;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewTileLayout {
    private static final boolean FILL_FROM_BOTTOM = false;
    @NotNull
    private final List<RenderPreview> myPreviews;
    @NotNull
    private final RenderContext myRenderContext;
    private final boolean myFixedOrder;
    private int myLayoutHeight;
    private Dimension myFixedRenderSize;

    public PreviewTileLayout(@NotNull List<RenderPreview> previews, @NotNull RenderContext renderContext, boolean fixedOrder) {
        if (previews == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previews", "com/android/tools/idea/rendering/multi/PreviewTileLayout", "<init>"));
        }
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/rendering/multi/PreviewTileLayout", "<init>"));
        }
        this.myPreviews = previews;
        this.myRenderContext = renderContext;
        this.myFixedOrder = fixedOrder;
    }

    @Nullable
    public Dimension getFixedRenderSize() {
        return this.myFixedRenderSize;
    }

    public void performLayout() {
        Rectangle clientArea = this.myRenderContext.getClientArea();
        int availableWidth = clientArea.width;
        int availableHeight = clientArea.height;
        availableWidth -= 12;
        Dimension fullImageSize = this.myRenderContext.getFullImageSize();
        ArrayList<RenderPreview> aspectOrder = new ArrayList<RenderPreview>(this.myPreviews);
        if (!this.myFixedOrder) {
            Collections.sort(aspectOrder, fullImageSize.width >= fullImageSize.height ? RenderPreview.DECREASING_ASPECT_RATIO : RenderPreview.INCREASING_ASPECT_RATIO);
        }
        int cellCount = aspectOrder.size() + 1;
        Pair<Integer, Integer> shape = this.computeOptimalShape(availableWidth, availableHeight, cellCount);
        int rows = (Integer)shape.getFirst();
        int columns = (Integer)shape.getSecond();
        int tileWidth = (availableWidth - 12 * (columns - 1)) / columns;
        int tileHeight = (availableHeight - 18 * (rows - 1) - 14 * rows) / rows;
        RenderPreview[][] grid = this.computeGrid(aspectOrder, fullImageSize, rows, columns);
        this.layoutRows(availableWidth, availableHeight, rows, columns, tileWidth, tileHeight, grid);
        this.myLayoutHeight = availableHeight;
    }

    private void layoutRows(int availableWidth, int availableHeight, int rows, int columns, int tileWidth, int tileHeight, RenderPreview[][] grid) {
        block10: {
            block9: {
                int row;
                int y = availableHeight - 2;
                int left = availableWidth - columns * tileWidth;
                if (left > 12) {
                    left -= 12;
                }
                for (row = rows - 1; row >= 0; --row) {
                    int last;
                    int rowHeight = 0;
                    for (int column = 0; column < columns; ++column) {
                        RenderPreview preview = grid[row][column];
                        if (preview == null) continue;
                        preview.setMaxSize(tileWidth, tileHeight);
                        rowHeight = Math.max(rowHeight, preview.getLayoutHeight());
                    }
                    if (row == 0) {
                        rowHeight = Math.max(rowHeight, tileHeight);
                    }
                    y -= rowHeight;
                    if (row < rows - 1) {
                        y -= 18;
                    }
                    if ((y -= 14) < 0 || row == 0 && rows == 2) {
                        y = 0;
                    }
                    this.layoutRow(availableHeight, rows, columns, tileWidth, tileHeight, grid[row], y, left, row, rowHeight);
                    if (row != rows - 1) continue;
                    for (last = columns - 1; last >= 0 && grid[rows - 1][last] == null; --last) {
                    }
                    if (last == -1 || last >= columns - 1) continue;
                    int x = left + last * (tileWidth + 12) - 12;
                    int max = availableWidth;
                    RenderPreview preview = grid[row][last];
                    int maxWidth = preview.getMaxWidth();
                    int maxHeight = preview.getMaxHeight();
                    int layoutWidth = preview.getLayoutWidth();
                    int layoutHeight = preview.getLayoutHeight();
                    preview.setMaxSize(Math.min(availableWidth - x, Math.max(maxWidth, max - x - 6)), Math.min(availableHeight - y, Math.max(maxHeight, rowHeight - 14)));
                    if (preview.getLayoutWidth() == layoutWidth && preview.getLayoutHeight() == layoutHeight) continue;
                    preview.setPosition(x + 6, y);
                }
                if (rows != 1) break block9;
                row = 0;
                for (int column = 0; column < columns; ++column) {
                    RenderPreview preview = grid[row][column];
                    if (preview == null) continue;
                    preview.setPosition(preview.getX(), (availableHeight - preview.getLayoutHeight()) / 2);
                }
                break block10;
            }
            if (columns != 1) break block10;
            int column = 0;
            for (int row = 0; row < rows; ++row) {
                RenderPreview preview = grid[row][column];
                if (preview == null) continue;
                preview.setPosition((availableWidth - preview.getLayoutWidth()) / 2, preview.getY());
            }
        }
    }

    private void layoutRow(int availableHeight, int rows, int columns, int tileWidth, int tileHeight, RenderPreview[] renderPreviews, int y, int left, int row, int rowHeight) {
        for (int column = 0; column < columns; ++column) {
            RenderPreview preview = renderPreviews[column];
            if (preview != null) {
                int x = left + column * (tileWidth + 12);
                preview.setPosition(x + (tileWidth - preview.getLayoutWidth()) / 2, y + (rowHeight - preview.getLayoutHeight()) / 2);
                preview.setVisible(true);
                continue;
            }
            if (row != 0 || column != 0) continue;
            int maxWidth = left + tileWidth;
            int maxHeight = 14 + tileHeight + availableHeight - rows * tileHeight - 18 * (rows - 1);
            this.myFixedRenderSize = new Dimension(maxWidth, maxHeight);
            this.myRenderContext.setMaxSize(this.myFixedRenderSize.width, this.myFixedRenderSize.height);
        }
    }

    private RenderPreview[][] computeGrid(List<RenderPreview> previews, Dimension fullImageSize, int rows, int columns) {
        int column;
        int row;
        RenderPreview[][] grid = new RenderPreview[rows][columns];
        if (columns > 1) {
            row = 0;
            column = 1;
        } else {
            row = 1;
            column = 0;
        }
        Iterator<RenderPreview> i$ = previews.iterator();
        while (i$.hasNext()) {
            RenderPreview preview;
            grid[row][column] = preview = i$.next();
            if (++column != columns) continue;
            column = 0;
            if (++row != rows) continue;
            break;
        }
        return grid;
    }

    private double pickAspectRatio() {
        double minAspect;
        double maxAspect = minAspect = this.myPreviews.get(0).getAspectRatio();
        for (RenderPreview preview : this.myPreviews) {
            double aspect = preview.getAspectRatio();
            if (aspect > maxAspect) {
                maxAspect = aspect;
            }
            if (!(aspect < minAspect)) continue;
            minAspect = aspect;
        }
        double aspect = minAspect < 1.0 && maxAspect > 1.0 ? 1.0 : (minAspect < 1.0 ? minAspect : maxAspect);
        return aspect;
    }

    private Pair<Integer, Integer> computeOptimalShape(int availableWidth, int availableHeight, int count) {
        double aspect = this.pickAspectRatio();
        int bestColumns = 1;
        int bestRows = count;
        int bestSize = 0;
        for (int columns = 1; columns <= count; ++columns) {
            int width;
            int height;
            int requiredHeight;
            int rows = count / columns;
            if (count % columns > 0) {
                ++rows;
            }
            if ((requiredHeight = (height = (int)((double)(width = (availableWidth - 12 * (columns - 1)) / columns) / aspect)) * rows + 18 * (rows - 1) + 14 * rows) > availableHeight) {
                height = (availableHeight - 18 * (rows - 1) - 14 * rows) / rows;
                width = (int)((double)height * aspect);
            }
            if (width <= bestSize) continue;
            bestSize = width;
            bestColumns = columns;
            bestRows = rows;
        }
        return Pair.create((Object)bestRows, (Object)bestColumns);
    }

    public int getLayoutHeight() {
        return this.myLayoutHeight;
    }
}

