/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.android.tools.idea.rendering.PsiResourceFile;
import com.android.tools.idea.rendering.PsiResourceItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalResourceRepository
extends AbstractResourceRepository
implements Disposable,
ModificationTracker {
    protected static final Logger LOG = Logger.getInstance(LocalResourceRepository.class);
    private final String myDisplayName;
    @Nullable
    private List<MultiResourceRepository> myParents;
    protected long myGeneration;

    protected LocalResourceRepository(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/rendering/LocalResourceRepository", "<init>"));
        }
        super(false);
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LocalResourceRepository", "getDisplayName"));
        }
        return string;
    }

    public void dispose() {
    }

    public final boolean isFramework() {
        return false;
    }

    public void addParent(@NonNull MultiResourceRepository parent) {
        if (this.myParents == null) {
            this.myParents = Lists.newArrayListWithExpectedSize((int)2);
        }
        this.myParents.add(parent);
    }

    public void removeParent(@NonNull MultiResourceRepository parent) {
        if (this.myParents != null) {
            this.myParents.remove((Object)parent);
        }
    }

    protected void invalidateItemCaches(ResourceType ... types) {
        if (this.myParents != null) {
            for (MultiResourceRepository parent : this.myParents) {
                parent.invalidateCache(this, types);
            }
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    @Nullable
    public VirtualFile getMatchingFile(@NonNull VirtualFile file, @NonNull ResourceType type, @NonNull FolderConfiguration config) {
        List<VirtualFile> matches = this.getMatchingFiles(file, type, config);
        return matches.isEmpty() ? null : matches.get(0);
    }

    @NonNull
    public List<VirtualFile> getMatchingFiles(@NonNull VirtualFile file, @NonNull ResourceType type, @NonNull FolderConfiguration config) {
        List matches = super.getMatchingFiles(ResourceHelper.getResourceName(file), type, config);
        ArrayList<VirtualFile> matchesFiles = new ArrayList<VirtualFile>(matches.size());
        for (ResourceFile match : matches) {
            if (match == null) continue;
            if (match instanceof PsiResourceFile) {
                matchesFiles.add(((PsiResourceFile)match).getPsiFile().getVirtualFile());
                continue;
            }
            matchesFiles.add(LocalFileSystem.getInstance().findFileByIoFile(match.getFile()));
        }
        return matchesFiles;
    }

    @Deprecated
    @Nullable
    public ResourceFile getMatchingFile(@NonNull String name, @NonNull ResourceType type, @NonNull FolderConfiguration config) {
        assert (name.indexOf(46) == -1) : name;
        return super.getMatchingFile(name, type, config);
    }

    public boolean isScanPending(@NonNull PsiFile psiFile) {
        return false;
    }

    @Nullable
    public static PsiFile getItemPsiFile(@NonNull Project project, @NonNull ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getPsiFile();
        }
        ResourceFile source = (ResourceFile)item.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof PsiResourceFile) {
            PsiResourceFile prf = (PsiResourceFile)source;
            return prf.getPsiFile();
        }
        File file = source.getFile();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            return psiManager.findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static XmlTag getItemTag(@NonNull Project project, @NonNull ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getTag();
        }
        PsiFile psiFile = LocalResourceRepository.getItemPsiFile(project, item);
        if (psiFile instanceof XmlFile) {
            String resourceName = item.getName();
            XmlFile xmlFile = (XmlFile)psiFile;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null && rootTag.isValid()) {
                XmlTag[] subTags;
                for (XmlTag tag : subTags = rootTag.getSubTags()) {
                    if (!tag.isValid() || !resourceName.equals(tag.getAttributeValue("name"))) continue;
                    return tag;
                }
            }
            assert (FolderTypeRelationship.getRelatedFolders((ResourceType)item.getType()).contains(ResourceFolderType.VALUES)) : item.getType();
        }
        return null;
    }

    @Nullable
    public String getViewTag(ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiResourceItem psiItem = (PsiResourceItem)item;
            XmlTag tag = psiItem.getTag();
            if (tag != null && tag.isValid()) {
                return tag.getName();
            }
            String id = item.getName();
            PsiFile file = psiItem.getPsiFile();
            if (file.isValid() && file instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)file).getRootTag()) != null && rootTag.isValid()) {
                return LocalResourceRepository.findViewTag(rootTag, id);
            }
        }
        return null;
    }

    @Nullable
    private static String findViewTag(XmlTag tag, String target) {
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null && id.endsWith(target) && target.equals(LintUtils.stripIdPrefix((String)id))) {
            return tag.getName();
        }
        for (XmlTag sub : tag.getSubTags()) {
            String found;
            if (!sub.isValid() || (found = LocalResourceRepository.findViewTag(sub, target)) == null) continue;
            return found;
        }
        return null;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }
}

