/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memory;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.memory.TimelineData;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemorySampler
implements Runnable,
AndroidDebugBridge.IClientChangeListener,
ClientData.IHprofDumpHandler {
    public static final int TYPE_UNREACHABLE = 0;
    public static final int TYPE_DATA = 1;
    public static final int TYPE_TIMEOUT = 2;
    public static final int TYPE_HPROF_REQUEST = 3;
    public static final int TYPE_HPROF_RESULT = 4;
    private static final Logger LOG = Logger.getInstance(MemorySampler.class);
    private static int ourLastHprofRequestId = 0;
    @NotNull
    private final List<MemorySamplerListener> myListeners;
    @NotNull
    private final TimelineData myData;
    @NotNull
    private final Semaphore myDataSemaphore;
    private final int mySampleFrequencyMs;
    @Nullable
    private volatile Future<?> myExecutingTask;
    @Nullable
    private volatile Client myClient;
    private volatile boolean myRunning;
    private int myPendingHprofId;

    MemorySampler(@NotNull TimelineData data, int sampleFrequencyMs) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/memory/MemorySampler", "<init>"));
        }
        this.myListeners = Lists.newLinkedList();
        this.mySampleFrequencyMs = sampleFrequencyMs;
        this.myData = data;
        this.myDataSemaphore = new Semaphore(0, true);
        this.myPendingHprofId = 0;
        this.myData.freeze();
    }

    private static int getNextHprofId() {
        return ++ourLastHprofRequestId;
    }

    private void sample(int type, int id) {
        float freeMb = 0.0f;
        float allocMb = 0.0f;
        if (this.myClient != null) {
            ClientData.HeapInfo m = this.myClient.getClientData().getVmHeapInfo(1);
            if (m != null) {
                allocMb = (float)m.bytesAllocated / 1048576.0f;
                freeMb = (float)m.sizeInBytes / 1048576.0f - allocMb;
            }
        } else {
            type = 0;
        }
        this.myData.add(System.currentTimeMillis(), type, id, allocMb, freeMb);
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/memory/MemorySampler", "clientChanged"));
        }
        if (this.myClient != null && this.myClient == client && (changeMask & 0x40) != 0) {
            this.myDataSemaphore.release();
        }
    }

    public void start() {
        if (this.myExecutingTask == null && this.myClient != null) {
            this.myData.clear();
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            this.myRunning = true;
            this.myExecutingTask = ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            this.myClient.setHeapInfoUpdateEnabled(true);
            for (MemorySamplerListener listener : this.myListeners) {
                listener.onStart();
            }
        }
    }

    public void stop() {
        if (this.myExecutingTask != null) {
            this.myRunning = false;
            this.myDataSemaphore.release();
            try {
                this.myExecutingTask.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            this.myData.freeze();
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            if (this.myClient != null) {
                this.myClient.setHeapInfoUpdateEnabled(false);
            }
            this.myExecutingTask = null;
            for (MemorySamplerListener listener : this.myListeners) {
                listener.onStop();
            }
        }
    }

    public boolean isRunning() {
        return this.myExecutingTask != null && this.myRunning;
    }

    @Override
    public void run() {
        boolean pending = false;
        long wait = this.mySampleFrequencyMs;
        while (this.myRunning) {
            try {
                long now = System.currentTimeMillis();
                if (this.myDataSemaphore.tryAcquire(wait, TimeUnit.MILLISECONDS)) {
                    pending = false;
                    this.sample(1, 0);
                } else {
                    Client client;
                    if (pending) {
                        this.sample(2, 0);
                    }
                    if ((client = this.myClient) != null) {
                        client.updateHeapInfo();
                    }
                    pending = true;
                }
                if ((wait -= System.currentTimeMillis() - now) > 0L) continue;
                wait = this.mySampleFrequencyMs;
            }
            catch (InterruptedException e) {
                this.myRunning = false;
            }
        }
    }

    public void onSuccess(String remoteFilePath, Client client) {
        LOG.warn("Unexpected HPROF dump in remote file path.");
    }

    public void onSuccess(final byte[] data, final Client client) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MemorySampler.this.myPendingHprofId == 0) {
                    return;
                }
                MemorySampler.this.sample(4, MemorySampler.this.myPendingHprofId);
                MemorySampler.this.myPendingHprofId = 0;
                for (MemorySamplerListener listener : MemorySampler.this.myListeners) {
                    listener.onHprofCompleted(data, client);
                }
            }
        });
    }

    public void onEndFailure(Client client, String message) {
        LOG.error("Error getting the HPROF dump.");
    }

    public boolean canRequestHeapDump() {
        return this.myPendingHprofId == 0;
    }

    public void requestHeapDump() {
        if (this.myClient != null) {
            ClientData.setHprofDumpHandler((ClientData.IHprofDumpHandler)this);
            this.myClient.dumpHprof();
            this.myPendingHprofId = MemorySampler.getNextHprofId();
            this.sample(3, this.myPendingHprofId);
        }
    }

    public void setClient(@Nullable Client client) {
        if (client != this.myClient) {
            this.stop();
            this.myClient = client;
            this.start();
        }
    }

    public void addListener(MemorySamplerListener listener) {
        this.myListeners.add(listener);
    }

    public void requestGc() {
        if (this.myClient != null) {
            this.myClient.executeGarbageCollector();
        }
    }

    public static interface MemorySamplerListener {
        public void onStart();

        public void onStop();

        public void onHprofCompleted(@NotNull byte[] var1, @NotNull Client var2);
    }
}

