/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memory;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.memory.MemorySampler;
import com.android.tools.idea.memory.TimelineComponent;
import com.android.tools.idea.memory.TimelineData;
import com.android.tools.idea.memory.actions.CloseMemoryMonitorWindow;
import com.android.tools.idea.memory.actions.GcAction;
import com.android.tools.idea.memory.actions.MemorySnapshotAction;
import com.android.tools.idea.memory.actions.RecordingAction;
import com.android.tools.idea.memory.actions.ToggleDebugRender;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryMonitorView
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener,
MemorySampler.MemorySamplerListener,
HierarchyListener,
AndroidDebugBridge.IDebugBridgeChangeListener {
    public static final int SAMPLES = 2048;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    @NotNull
    private final Project myProject;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Map<String, String> myPreferredClients;
    public boolean myIgnoreActionEvents;
    @NotNull
    private JPanel myContentPane;
    @NotNull
    private TimelineComponent myTimelineComponent;
    @NotNull
    private JPanel myToolbarPanel;
    @NotNull
    private JComboBox myDeviceCombo;
    @NotNull
    private JComboBox myClientCombo;
    private JPanel myTopPanel;
    @NotNull
    private MemorySampler myMemorySampler;
    @NotNull
    private TimelineData myData;
    @Nullable
    private String myCandidateClientName;
    @NotNull
    private MemorySamplerTask myMemorySamplerTask;

    public MemoryMonitorView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/memory/MemoryMonitorView", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myProject = project;
        this.myPreferredClients = Maps.newHashMap();
        this.myCandidateClientName = this.getApplicationName();
        this.myTimelineComponent.configureUnits("MB");
        this.myTimelineComponent.configureStream(0, "Allocated", new JBColor(7908313, 7908313));
        this.myTimelineComponent.configureStream(1, "Free", new JBColor(12242140, 5331036));
        this.myTimelineComponent.configureEvent(3, 4, 0, AndroidIcons.Ddms.ScreenCapture, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543));
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.myTopPanel.setBackground(BACKGROUND_COLOR);
        this.myMemorySampler = new MemorySampler(this.myData, 500);
        this.myMemorySampler.addListener(this);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.getToolbarActions(), false);
        this.myToolbarPanel.add(toolbar.getComponent());
        this.myToolbarPanel.setBorder(IdeBorderFactory.createBorder((int)4));
        this.myContentPane.addHierarchyListener(this);
        this.myMemorySamplerTask = new MemorySamplerTask(project, this.myMemorySampler);
        this.initializeDeviceCombo();
        this.initializeClientCombo();
        AndroidSdkUtils.activateDdmsIfNecessary(this.myProject);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    private void initializeClientCombo() {
        this.myClientCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MemoryMonitorView.this.myIgnoreActionEvents) {
                    return;
                }
                Client client = (Client)MemoryMonitorView.this.myClientCombo.getSelectedItem();
                MemoryMonitorView.this.myPreferredClients.put(client.getDevice().getName(), client.getClientData().getClientDescription());
                MemoryMonitorView.this.myMemorySampler.setClient(client);
            }
        });
        this.myClientCombo.setRenderer(new ClientCellRenderer("No Debuggable Applications"));
        Dimension size = this.myClientCombo.getMinimumSize();
        this.myClientCombo.setMinimumSize(new Dimension(250, size.height));
    }

    private void initializeDeviceCombo() {
        this.myDeviceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MemoryMonitorView.this.myIgnoreActionEvents) {
                    return;
                }
                MemoryMonitorView.this.updateClientCombo();
            }
        });
        this.myDeviceCombo.setRenderer(new DeviceRenderer.DeviceComboBoxRenderer("No Connected Devices"));
        Dimension size = this.myDeviceCombo.getMinimumSize();
        this.myDeviceCombo.setMinimumSize(new Dimension(200, size.height));
    }

    private void createUIComponents() {
        float bufferTimeInSeconds = 0.75f;
        float initialMax = 5.0f;
        float initialMarker = 2.0f;
        this.myData = new TimelineData(2, 2048);
        this.myTimelineComponent = new TimelineComponent(this.myData, bufferTimeInSeconds, initialMax, initialMarker);
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (Boolean.getBoolean("enable.experimental.actions")) {
            group.add((AnAction)new RecordingAction(this.myMemorySampler));
            group.add((AnAction)new MemorySnapshotAction(this.myMemorySampler));
        }
        group.add((AnAction)new GcAction(this.myMemorySampler));
        group.add((AnAction)new CloseMemoryMonitorWindow(this));
        if (Boolean.getBoolean("studio.profiling.debug")) {
            group.addSeparator();
            group.add((AnAction)new ToggleDebugRender(this.myTimelineComponent));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/memory/MemoryMonitorView", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    @Nullable
    private String getApplicationName() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public JPanel getComponent() {
        return this.myContentPane;
    }

    public void close() {
        this.myMemorySampler.stop();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Memory Monitor");
        toolWindow.hide(null);
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.myBridge = bridge;
        this.updateDeviceCombo();
    }

    public void deviceConnected(IDevice device) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                MemoryMonitorView.this.updateDeviceCombo();
            }
        });
    }

    public void deviceDisconnected(IDevice device) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                MemoryMonitorView.this.updateDeviceCombo();
            }
        });
    }

    public void deviceChanged(IDevice device, final int changeMask) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if ((changeMask & 2) != 0) {
                    MemoryMonitorView.this.updateClientCombo();
                }
            }
        });
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryMonitorView.this.updateClientCombo();
                }
            });
        }
    }

    private void updateDeviceCombo() {
        this.myIgnoreActionEvents = true;
        boolean update = true;
        IDevice selected = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        if (this.myBridge != null) {
            for (IDevice device : this.myBridge.getDevices()) {
                this.myDeviceCombo.addItem(device);
                if (selected != device) continue;
                this.myDeviceCombo.setSelectedItem(device);
                update = false;
            }
        }
        if (update) {
            this.updateClientCombo();
        }
        this.myIgnoreActionEvents = false;
    }

    private void updateClientCombo() {
        Client selected;
        this.myIgnoreActionEvents = true;
        IDevice device = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client toSelect = selected = (Client)this.myClientCombo.getSelectedItem();
        boolean update = true;
        this.myClientCombo.removeAllItems();
        if (device != null) {
            Client preferredClient;
            String preferred = this.getPreferredClientForDevice(device.getName());
            if (preferred != null && (preferredClient = device.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            Client[] clients = device.getClients();
            Arrays.sort(clients, new ClientCellRenderer.ClientComparator());
            for (Client client : clients) {
                this.myClientCombo.addItem(client);
                if (client != toSelect) continue;
                this.myClientCombo.setSelectedItem(toSelect);
                update = toSelect != selected;
            }
        }
        this.myIgnoreActionEvents = false;
        if (update) {
            selected = (Client)this.myClientCombo.getSelectedItem();
            this.myMemorySampler.setClient(selected);
        }
    }

    @Nullable
    private String getPreferredClientForDevice(String deviceName) {
        String client = this.myPreferredClients.get(deviceName);
        return client == null ? this.myCandidateClientName : client;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onHprofCompleted(@NotNull byte[] data, @NotNull Client client) {
        File f;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/memory/MemoryMonitorView", "onHprofCompleted"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/memory/MemoryMonitorView", "onHprofCompleted"));
        }
        try {
            f = FileUtil.createTempFile((String)"ddms", (String)".hprof");
            FileUtil.writeToFile((File)f, (byte[])data);
        }
        catch (IOException e) {
            return;
        }
        VirtualFile vf = VfsUtil.findFileByIoFile((File)f, (boolean)true);
        if (vf == null) {
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, vf);
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
            this.myMemorySamplerTask.exit();
            if (this.myContentPane.isShowing()) {
                this.myMemorySampler.start();
            } else if (this.myMemorySampler.isRunning()) {
                this.myMemorySamplerTask = new MemorySamplerTask(this.myProject, this.myMemorySampler);
                ProgressManager.getInstance().run((Task)this.myMemorySamplerTask);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        this.myToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 2, 1, 3, new Dimension(32, -1), null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel4.setOpaque(true);
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myDeviceCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClientCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        TimelineComponent timelineComponent = this.myTimelineComponent;
        jPanel4.add((Component)timelineComponent, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class MemorySamplerTask
    extends Task.Backgroundable {
        private final MemorySampler myMemorySampler;
        private final CountDownLatch myLatch;

        public MemorySamplerTask(@Nullable Project project, MemorySampler memorySampler) {
            super(project, "Monitoring Memory ...", true);
            this.myMemorySampler = memorySampler;
            this.myLatch = new CountDownLatch(1);
        }

        public void exit() {
            this.myLatch.countDown();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/memory/MemoryMonitorView$MemorySamplerTask", "run"));
            }
            indicator.setIndeterminate(true);
            while (this.myMemorySampler.isRunning() && this.myLatch.getCount() > 0L) {
                try {
                    this.myLatch.await(200L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!indicator.isCanceled()) continue;
                this.myMemorySampler.stop();
                break;
            }
        }
    }
}

