/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memory;

import java.util.AbstractList;
import org.jetbrains.annotations.NotNull;

class CircularArrayList<T>
extends AbstractList<T> {
    @NotNull
    private final T[] myData;
    private int mySize;
    private int myStart;

    CircularArrayList(int alloc) {
        this.myData = new Object[alloc];
        this.mySize = 0;
        this.myStart = 0;
    }

    @Override
    public T get(int i) {
        if (i >= this.mySize) {
            throw new IndexOutOfBoundsException();
        }
        return this.myData[(this.myStart + i) % this.mySize];
    }

    @Override
    public boolean add(T t) {
        if (this.mySize == this.myData.length) {
            this.myData[this.myStart] = t;
            this.myStart = (this.myStart + 1) % this.mySize;
        } else {
            this.myData[this.mySize] = t;
            ++this.mySize;
        }
        return true;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myStart = 0;
        this.mySize = 0;
    }
}

