/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesUtil {
    private PropertiesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Properties getProperties(@NotNull File filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/util/PropertiesUtil", "getProperties"));
        }
        if (filePath.isDirectory()) {
            throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", filePath.getPath()));
        }
        if (!filePath.exists()) {
            Properties properties = new Properties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/PropertiesUtil", "getProperties"));
            }
            return properties;
        }
        Properties properties = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(filePath)), Charsets.UTF_8);
            properties.load(reader);
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)true);
        Properties properties2 = properties;
        if (properties2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/PropertiesUtil", "getProperties"));
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePropertiesToFile(@NotNull Properties properties, @NotNull File filePath, @Nullable String comments) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/util/PropertiesUtil", "savePropertiesToFile"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/gradle/util/PropertiesUtil", "savePropertiesToFile"));
        }
        FileUtilRt.createParentDirs((File)filePath);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            properties.store(out, comments);
        }
        finally {
            Closeables.close((Closeable)out, (boolean)true);
        }
    }
}

