/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    private static final Logger LOG = Logger.getInstance(EmbeddedDistributionPaths.class);

    @Nullable
    public static File findAndroidStudioLocalMavenRepoPath() {
        File repoPath;
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            repoPath = new File(defaultRootDirPath, "m2repository");
        } else {
            String relativePath = FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2");
            repoPath = new File(FileUtil.toCanonicalPath((String)(FileUtil.toSystemDependentName((String)PathManager.getHomePath()) + relativePath)));
        }
        LOG.info("Looking for embedded Maven repo at '" + repoPath.getPath() + "'");
        return repoPath.isDirectory() ? repoPath : null;
    }

    @Nullable
    public static File findEmbeddedGradleDistributionPath() {
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            File embeddedPath = new File(defaultRootDirPath, "gradle-2.2.1");
            LOG.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            return embeddedPath.isDirectory() ? embeddedPath : null;
        }
        return null;
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = FileUtil.toSystemDependentName((String)PathManager.getHomePath());
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }
}

