/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class StopGradleDaemonsHyperlink
extends NotificationHyperlink {
    @NotNull
    public static NotificationHyperlink createStopGradleDaemonsHyperlink() {
        if (ApplicationManager.getApplication().isRestartCapable()) {
            StopGradleDaemonsHyperlink stopGradleDaemonsHyperlink = new StopGradleDaemonsHyperlink();
            if (stopGradleDaemonsHyperlink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/hyperlink/StopGradleDaemonsHyperlink", "createStopGradleDaemonsHyperlink"));
            }
            return stopGradleDaemonsHyperlink;
        }
        OpenUrlHyperlink openUrlHyperlink = new OpenUrlHyperlink("http://www.gradle.org/docs/current/userguide/gradle_daemon.html", "Open Gradle Daemon documentation");
        if (openUrlHyperlink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/hyperlink/StopGradleDaemonsHyperlink", "createStopGradleDaemonsHyperlink"));
        }
        return openUrlHyperlink;
    }

    private StopGradleDaemonsHyperlink() {
        super("stopGradleDaemons", "Stop Gradle build processes (requires restart)");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/StopGradleDaemonsHyperlink", "execute"));
        }
        String message = "Stopping all Gradle daemons will terminate any running Gradle builds (e.g. from the command line).\nThis action will also restart the IDE.\n\nDo you want to continue?";
        String title = "Stop Gradle Daemons";
        int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            GradleUtil.stopAllGradleDaemons();
            ApplicationManager.getApplication().restart();
        }
    }
}

