/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class FixGradleVersionInWrapperHyperlink
extends NotificationHyperlink {
    @NotNull
    private final File myWrapperPropertiesFile;
    @NotNull
    private final String myGradleVersion;

    @Nullable
    public static NotificationHyperlink createIfProjectUsesGradleWrapper(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "createIfProjectUsesGradleWrapper"));
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            return new FixGradleVersionInWrapperHyperlink(wrapperPropertiesFile, "2.2.1");
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(@NotNull File wrapperPropertiesFile, @NotNull String gradleVersion) {
        if (wrapperPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperPropertiesFile", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "<init>"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "<init>"));
        }
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project");
        this.myWrapperPropertiesFile = wrapperPropertiesFile;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "execute"));
        }
        FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        GradleProjectSettings settings = GradleUtil.getGradleProjectSettings(project);
        if (settings != null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }

    @Override
    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "executeIfClicked"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "executeIfClicked"));
        }
        boolean updated = FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        if (updated) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
        }
        return updated;
    }

    static boolean updateGradleVersion(@NotNull Project project, @NotNull File wrapperPropertiesFile, @NotNull String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "updateGradleVersion"));
        }
        if (wrapperPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperPropertiesFile", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "updateGradleVersion"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleVersionInWrapperHyperlink", "updateGradleVersion"));
        }
        try {
            boolean updated = GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFile);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)wrapperPropertiesFile, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)project, (String)msg, (String)"Quick Fix Failed");
        }
        return false;
    }
}

