/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixGradleModelVersionHyperlink
extends NotificationHyperlink {
    private static final Logger LOG = Logger.getInstance(FixGradleModelVersionHyperlink.class);
    private final boolean myOpenMigrationGuide;

    public FixGradleModelVersionHyperlink() {
        this("Open migration guide, fix plug-in version and sync project", true);
    }

    public FixGradleModelVersionHyperlink(@NotNull String text, boolean openMigrationGuide) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleModelVersionHyperlink", "<init>"));
        }
        super("fixGradleElements", text);
        this.myOpenMigrationGuide = openMigrationGuide;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleModelVersionHyperlink", "execute"));
        }
        if (this.myOpenMigrationGuide) {
            BrowserUtil.browse((String)"http://tools.android.com/tech-docs/new-build-system/migrating-to-1-0-0");
        }
        if (FixGradleModelVersionHyperlink.updateGradlePluginVersion(project)) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
            return;
        }
        String msg = "Unable to find any references to the Android Gradle plugin in build.gradle files.\n\nPlease click the link to perform a textual search and then update the build files manually.";
        SearchInBuildFilesHyperlink hyperlink = new SearchInBuildFilesHyperlink("com.android.tools.build:gradle:");
        AndroidGradleNotification.getInstance(project).showBalloon("Quick Fix Failed", msg, NotificationType.ERROR, hyperlink);
    }

    private static boolean updateGradlePluginVersion(final @NotNull Project project) {
        File wrapperPropertiesFilePath;
        FullRevision current;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleModelVersionHyperlink", "updateGradlePluginVersion"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return false;
        }
        final Ref atLeastOneUpdated = new Ref((Object)false);
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                boolean updated;
                Document document;
                if ("build.gradle".equals(virtualFile.getName()) && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null && (updated = GradleUtil.updateGradleDependencyVersion(project, document, "com.android.tools.build:gradle:", new Computable<String>(){

                    public String compute() {
                        return "1.1.1";
                    }
                }))) {
                    atLeastOneUpdated.set((Object)true);
                }
                return true;
            }
        });
        boolean updated = (Boolean)atLeastOneUpdated.get();
        if (updated && (current = FixGradleModelVersionHyperlink.getGradleWrapperVersion(wrapperPropertiesFilePath = GradleUtil.getGradleWrapperPropertiesFilePath(new File(project.getBasePath())))) != null && !GradleUtil.isSupportedGradleVersion(current)) {
            try {
                GradleUtil.updateGradleDistributionUrl("2.2.1", wrapperPropertiesFilePath);
            }
            catch (IOException e) {
                LOG.warn("Failed to update Gradle version in wrapper", (Throwable)e);
            }
        }
        return updated;
    }

    @Nullable
    private static FullRevision getGradleWrapperVersion(File wrapperPropertiesFilePath) {
        String version = null;
        try {
            version = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFilePath);
        }
        catch (IOException e) {
            LOG.warn("Failed to obtain Gradle version in wrapper", (Throwable)e);
        }
        if (StringUtil.isNotEmpty((String)version)) {
            try {
                return FullRevision.parseRevision((String)version);
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse Gradle version " + version, (Throwable)e);
            }
        }
        return null;
    }
}

