/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class CreateGradleWrapperHyperlink
extends NotificationHyperlink {
    public CreateGradleWrapperHyperlink() {
        super("createGradleWrapper", "Migrate to Gradle wrapper and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/CreateGradleWrapperHyperlink", "execute"));
        }
        File projectDirPath = new File(project.getBasePath());
        try {
            GradleUtil.createGradleWrapper(projectDirPath);
            GradleProjectSettings settings = GradleUtil.getGradleProjectSettings(project);
            if (settings != null) {
                settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            }
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)("Failed to create Gradle wrapper: " + e.getMessage()), (String)"Quick Fix");
        }
    }
}

