/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;

@State(name="GradleExperimentalSettings", storages={@Storage(file="$APP_CONFIG$/gradle.experimental.xml")})
public class GradleExperimentalSettings
implements PersistentStateComponent<GradleExperimentalSettings> {
    public boolean SELECT_MODULES_ON_PROJECT_IMPORT;
    public boolean ENABLE_UNIT_TESTING_SUPPORT;

    @NotNull
    public static GradleExperimentalSettings getInstance() {
        GradleExperimentalSettings gradleExperimentalSettings = (GradleExperimentalSettings)ServiceManager.getService(GradleExperimentalSettings.class);
        if (gradleExperimentalSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleExperimentalSettings", "getInstance"));
        }
        return gradleExperimentalSettings;
    }

    public void setUnitTestingSupportEnabled(boolean enabled) {
        this.ENABLE_UNIT_TESTING_SUPPORT = enabled;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    if (project.isDefault() || !project.isOpen() || project.isDisposed()) continue;
                    BuildVariantView.getInstance(project).updateTestArtifactComboBox();
                }
            }
        });
    }

    @NotNull
    public GradleExperimentalSettings getState() {
        GradleExperimentalSettings gradleExperimentalSettings = this;
        if (gradleExperimentalSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleExperimentalSettings", "getState"));
        }
        return gradleExperimentalSettings;
    }

    public void loadState(GradleExperimentalSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }
}

