/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker.messages;

import com.android.tools.idea.ui.MultilineColoredTreeCellRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageTreeRenderer
extends MultilineColoredTreeCellRenderer {
    private static final Pattern ourLinkPattern = Pattern.compile("<a\\s+href=['\"]([^'\"]+)['\"]>(.+?)</a>");

    MessageTreeRenderer() {
    }

    @Override
    protected void initComponent(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/gradle/invoker/messages/MessageTreeRenderer", "initComponent"));
        }
        ErrorTreeElement element = MessageTreeRenderer.getElement(value);
        if (element != null) {
            String[] text = element.getText();
            if (text == null) {
                text = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (text.length > 0 && text[0] == null) {
                text[0] = "";
            }
            final Consumer hyperlinkAction = element instanceof SimpleMessageElement && element.getData() instanceof Consumer ? (Consumer)element.getData() : null;
            for (int i = 0; i < text.length; ++i) {
                String line = text[i];
                Matcher matcher = ourLinkPattern.matcher(line);
                int start = 0;
                while (start < line.length()) {
                    boolean matched = matcher.find(start);
                    if (matched) {
                        if (matcher.start() > start) {
                            this.append(line.substring(start, matcher.start()));
                        }
                        final String href = matcher.group(1);
                        this.append(matcher.group(2), SimpleTextAttributes.LINK_ATTRIBUTES, hyperlinkAction == null ? null : new Runnable(){

                            @Override
                            public void run() {
                                hyperlinkAction.consume((Object)href);
                            }
                        });
                        start = matcher.end();
                        continue;
                    }
                    if (start >= line.length()) break;
                    this.append(line.substring(start));
                    break;
                }
                if (i >= text.length - 1) continue;
                this.appendLineBreak();
            }
        }
        Icon icon = null;
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            icon = groupingElement.getFile() != null ? groupingElement.getFile().getFileType().getIcon() : AllIcons.FileTypes.Java;
        } else if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            ErrorTreeElementKind kind = element.getKind();
            icon = MessageTreeRenderer.getIconFor(kind);
        }
        if (icon == null) {
            icon = EmptyIcon.ICON_16;
        }
        this.setIcon(icon);
    }

    @NotNull
    private static Icon getIconFor(@NotNull ErrorTreeElementKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/android/tools/idea/gradle/invoker/messages/MessageTreeRenderer", "getIconFor"));
        }
        switch (kind) {
            case ERROR: {
                Icon icon = AllIcons.General.BalloonError;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/messages/MessageTreeRenderer", "getIconFor"));
                }
                return icon;
            }
            case WARNING: {
                Icon icon = AllIcons.General.BalloonWarning;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/messages/MessageTreeRenderer", "getIconFor"));
                }
                return icon;
            }
            case INFO: {
                Icon icon = AllIcons.General.BalloonInformation;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/messages/MessageTreeRenderer", "getIconFor"));
                }
                return icon;
            }
        }
        Icon icon = EmptyIcon.ICON_16;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/messages/MessageTreeRenderer", "getIconFor"));
        }
        return icon;
    }

    @Nullable
    private static ErrorTreeElement getElement(@Nullable Object value) {
        Object userObject;
        if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ErrorTreeNodeDescriptor) {
            return ((ErrorTreeNodeDescriptor)userObject).getElement();
        }
        return null;
    }
}

