/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsWriteUtils {
    public static boolean setAttributeForItems(@NotNull Project project, final @NotNull String attribute, final @Nullable String value, @NotNull List<ResourceItem> items) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringsWriteUtils", "setAttributeForItems"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/strings/StringsWriteUtils", "setAttributeForItems"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/editors/strings/StringsWriteUtils", "setAttributeForItems"));
        }
        if (items.isEmpty()) {
            return false;
        }
        final ArrayList tags = Lists.newArrayListWithExpectedSize((int)items.size());
        HashSet files = Sets.newHashSetWithExpectedSize((int)items.size());
        for (ResourceItem item : items) {
            XmlTag tag = StringResourceData.resourceToXmlTag(item);
            if (tag == null) {
                return false;
            }
            tags.add(tag);
            files.add(tag.getContainingFile());
        }
        final boolean deleteTag = attribute.equals("name") && (value == null || value.isEmpty());
        new WriteCommandAction.Simple(project, "Setting attribute " + attribute, files.toArray(new PsiFile[files.size()])){

            public void run() {
                for (XmlTag tag : tags) {
                    if (deleteTag) {
                        tag.delete();
                        continue;
                    }
                    tag.setAttribute(attribute, value);
                }
            }
        }.execute();
        return true;
    }

    public static boolean setItemText(@NotNull Project project, @NotNull ResourceItem item, final @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringsWriteUtils", "setItemText"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/strings/StringsWriteUtils", "setItemText"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/strings/StringsWriteUtils", "setItemText"));
        }
        if (value.isEmpty()) {
            return StringsWriteUtils.setAttributeForItems(project, "name", null, Collections.singletonList(item));
        }
        final XmlTag tag = StringResourceData.resourceToXmlTag(item);
        if (tag != null) {
            new WriteCommandAction.Simple(project, "Setting value of " + item.getName(), new PsiFile[]{tag.getContainingFile()}){

                public void run() {
                    tag.getValue().setEscapedText(value);
                }
            }.execute();
            return true;
        }
        return false;
    }

    @Nullable
    public static ResourceItem createItem(final @NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, final @Nullable Locale locale, final @NotNull String name, final @NotNull String value, final boolean translatable) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringsWriteUtils", "createItem"));
        }
        if (resFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFolder", "com/android/tools/idea/editors/strings/StringsWriteUtils", "createItem"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/strings/StringsWriteUtils", "createItem"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/strings/StringsWriteUtils", "createItem"));
        }
        Project project = facet.getModule().getProject();
        XmlFile resourceFile = StringsWriteUtils.getStringResourceFile(project, resFolder, locale);
        if (resourceFile == null) {
            return null;
        }
        final XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        new WriteCommandAction.Simple(project, "Creating string " + name, new PsiFile[]{resourceFile}){

            public void run() {
                XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), value, false);
                child.setAttribute("name", name);
                child.setAttribute("translatable", translatable ? null : "false");
                root.addSubTag(child, false);
            }
        }.execute();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringsWriteUtils.getStringResourceItem(facet, name, locale);
        }
        return (ResourceItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceItem>(){

            public ResourceItem compute() {
                return StringsWriteUtils.getStringResourceItem(facet, name, locale);
            }
        });
    }

    @Nullable
    private static ResourceItem getStringResourceItem(@NotNull AndroidFacet facet, @NotNull String key, @Nullable Locale locale) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringsWriteUtils", "getStringResourceItem"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/strings/StringsWriteUtils", "getStringResourceItem"));
        }
        LocalResourceRepository repository = facet.getModuleResources(true);
        repository.sync();
        List items = repository.getResourceItem(ResourceType.STRING, key);
        if (items == null) {
            return null;
        }
        for (ResourceItem item : items) {
            Locale l;
            LanguageQualifier languageQualifier;
            FolderConfiguration config = item.getConfiguration();
            LanguageQualifier languageQualifier2 = languageQualifier = config == null ? null : config.getEffectiveLanguage();
            if (!(languageQualifier == null ? locale == null : (l = Locale.create(languageQualifier, config.getEffectiveRegion())).equals(locale))) continue;
            return item;
        }
        return null;
    }

    @Nullable
    private static XmlFile getStringResourceFile(@NotNull Project project, final @NotNull VirtualFile resFolder, @Nullable Locale locale) {
        XmlFile resourceFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringsWriteUtils", "getStringResourceFile"));
        }
        if (resFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFolder", "com/android/tools/idea/editors/strings/StringsWriteUtils", "getStringResourceFile"));
        }
        FolderConfiguration configuration = new FolderConfiguration();
        if (locale != null) {
            configuration.setLanguageQualifier(locale.language);
            if (locale.hasRegion()) {
                configuration.setRegionQualifier(locale.region);
            }
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        final String valuesFolderName = configuration.getFolderName(ResourceFolderType.VALUES);
        VirtualFile valuesFolder = resFolder.findChild(valuesFolderName);
        if (valuesFolder == null && (valuesFolder = (VirtualFile)new WriteCommandAction<VirtualFile>(project, "Creating directory " + valuesFolderName, new PsiFile[]{manager.findFile(resFolder)}){

            public void run(@NotNull Result<VirtualFile> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/strings/StringsWriteUtils$5", "run"));
                }
                try {
                    result.setResult((Object)resFolder.createChildDirectory((Object)this, valuesFolderName));
                }
                catch (IOException ex) {
                    result.setResult(null);
                }
            }
        }.execute().getResultObject()) == null) {
            return null;
        }
        String resourceFileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
        if (resourceFileName == null) {
            return null;
        }
        VirtualFile resourceVirtualFile = valuesFolder.findChild(resourceFileName);
        if (resourceVirtualFile == null) {
            PsiDirectory valuesDir = manager.findDirectory(valuesFolder);
            if (valuesDir == null) {
                return null;
            }
            try {
                resourceFile = AndroidResourceUtil.createFileResource(resourceFileName, valuesDir, "", ResourceType.STRING.getName(), true);
            }
            catch (Exception ex) {
                return null;
            }
        } else {
            PsiFile resourcePsiFile = manager.findFile(resourceVirtualFile);
            if (!(resourcePsiFile instanceof XmlFile)) {
                return null;
            }
            resourceFile = (XmlFile)resourcePsiFile;
        }
        return resourceFile;
    }
}

