/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Map;

public class Instantiation {
    public static PsiElement instantiate(PsiMethod method, final Map<String, PsiElement> bindings) {
        PsiParameterList parameterList = method.getParameterList();
        for (PsiParameter parameter : parameterList.getParameters()) {
            assert (bindings.containsKey(parameter.getName()));
        }
        PsiElement body = method.getBody().getStatements()[0].getFirstChild();
        PsiElement result = body.copy();
        result.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitIdentifier(PsiIdentifier identifier) {
                PsiElement newElement = (PsiElement)bindings.get(identifier.getText());
                if (newElement != null) {
                    identifier.replace(newElement);
                }
            }
        });
        return result;
    }

    public static String instantiate2(PsiMethod method, Map<String, String> bindings) {
        PsiParameterList parameterList = method.getParameterList();
        for (PsiParameter parameter : parameterList.getParameters()) {
            assert (bindings.containsKey(parameter.getName()));
        }
        PsiElement body = method.getBody().getStatements()[0].getFirstChild();
        String result = body.getText();
        result = Instantiation.replaceAll(result, ".$()", "");
        for (Map.Entry<String, String> entry : bindings.entrySet()) {
            result = Instantiation.replaceAll(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static String replaceAll(String result, String key, String value) {
        while (result.contains(key)) {
            result = result.replace(key, value);
        }
        return result;
    }
}

