/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utilities {
    public static final Dimension ZERO_SIZE = new Dimension(0, 0);
    static final Color TRANSITION_LINE_COLOR = new JBColor(new Color(80, 80, 255), new Color(40, 40, 255));

    public static Point sum(Point p1, Point p2) {
        return new Point(p1.x + p2.x, p1.y + p2.y);
    }

    public static Point diff(Point p1, Point p2) {
        return new Point(p1.x - p2.x, p1.y - p2.y);
    }

    public static double length(Point p) {
        return Math.sqrt(p.x * p.x + p.y * p.y);
    }

    public static Point max(Point p1, Point p2) {
        return new Point(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
    }

    public static Point scale(Point p, float k) {
        return new Point((int)(k * (float)p.x), (int)(k * (float)p.y));
    }

    public static Dimension scale(Dimension d, float k) {
        return new Dimension((int)(k * (float)d.width), (int)(k * (float)d.height));
    }

    private static int snap(int i, int d) {
        return (int)Math.round((double)i / (double)d) * d;
    }

    public static Point snap(Point p, Dimension gridSize) {
        return new Point(Utilities.snap(p.x, gridSize.width), Utilities.snap(p.y, gridSize.height));
    }

    public static Point midPoint(Point p1, Point p2) {
        return Utilities.scale(Utilities.sum(p1, p2), 0.5f);
    }

    public static Point midPoint(Dimension size) {
        return Utilities.point(Utilities.scale(size, 0.5f));
    }

    public static Point point(Dimension d) {
        return new Point(d.width, d.height);
    }

    public static Dimension dimension(Point p) {
        return new Dimension(Math.abs(p.x), Math.abs(p.y));
    }

    public static Point project(Point p, Rectangle r) {
        return new Point(Utilities.bound(p.x, Utilities.x1(r), Utilities.x2(r)), Utilities.bound(p.y, Utilities.y1(r), Utilities.y2(r)));
    }

    public static Point centre(@NotNull Rectangle r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/android/tools/idea/editors/navigation/Utilities", "centre"));
        }
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public static String getXmlFileNameFromJavaFileName(String javaFileName) {
        if (javaFileName.endsWith(".java")) {
            javaFileName = javaFileName.substring(0, javaFileName.length() - 5);
        }
        char[] charsJava = javaFileName.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charsJava.length; ++i) {
            char currentChar = charsJava[i];
            if (Character.isUpperCase(currentChar) && i != 0) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toLowerCase(currentChar));
        }
        return stringBuilder.toString();
    }

    public static String getJavaFileNameFromXmlFileName(String xmlFileName) {
        if (xmlFileName.endsWith(".xml")) {
            xmlFileName = xmlFileName.substring(0, xmlFileName.length() - 4);
        }
        char[] charsXml = xmlFileName.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toUpperCase(charsXml[0]));
        for (int i = 1; i < charsXml.length; ++i) {
            char currentChar = charsXml[i];
            if (currentChar == '_') {
                char toAppend = Character.toUpperCase(charsXml[++i]);
                stringBuilder.append(toAppend);
                continue;
            }
            stringBuilder.append(currentChar);
        }
        return stringBuilder.toString();
    }

    static void drawArrow(Graphics g1, int x1, int y1, int x2, int y2, int lineWidth) {
        Graphics2D g = (Graphics2D)g1.create();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform t = AffineTransform.getTranslateInstance(x1, y1);
        t.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(t);
        g.drawLine(0, 0, len, 0);
        Dimension arrowHeadSize = new Dimension(lineWidth * 6, lineWidth * 3);
        int basePosition = len - arrowHeadSize.width;
        int height = arrowHeadSize.height;
        g.fillPolygon(new int[]{len, basePosition, basePosition, len}, new int[]{0, -height, height, 0}, 4);
    }

    static <T> Condition<T> not(final Condition<T> condition) {
        return new Condition<T>(){

            public boolean value(T t) {
                return !condition.value(t);
            }
        };
    }

    static <T> Condition<T> instanceOf(final Class<?> type) {
        return new Condition<T>(){

            public boolean value(Object o) {
                return type.isAssignableFrom(o.getClass());
            }
        };
    }

    static int sign(int x) {
        return x > 0 ? 1 : (x < 0 ? -1 : 0);
    }

    static Dimension notNull(@Nullable Dimension d) {
        return d == null ? ZERO_SIZE : d;
    }

    @Nullable
    public static PsiClass getPsiClass(Module module, String className) {
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = module.getModuleWithLibrariesScope();
        return facade.findClass(className, scope);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass psiClass, @NotNull String signature) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/android/tools/idea/editors/navigation/Utilities", "findMethodBySignature"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/android/tools/idea/editors/navigation/Utilities", "findMethodBySignature"));
        }
        PsiMethod template = Utilities.createMethodFromText(psiClass, signature);
        return psiClass.findMethodBySignature(template, false);
    }

    public static PsiMethod createMethodFromText(PsiClass psiClass, String text) {
        return Utilities.createMethodFromText(psiClass.getProject(), text, (PsiElement)psiClass);
    }

    public static PsiMethod createMethodFromText(Project project, String text, @Nullable PsiElement context) {
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createMethodFromText(text, context);
    }

    @Nullable
    public static VirtualFile virtualFile(File file) {
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static VirtualFile mkDirs(VirtualFile dir, String path) throws IOException {
        for (String dirName : path.split("/")) {
            VirtualFile existingDir = dir.findFileByRelativePath(dirName);
            dir = existingDir != null ? existingDir : dir.createChildDirectory(null, dirName);
        }
        return dir;
    }

    public static VirtualFile getNavigationFile(final VirtualFile baseDir, String moduleName, String deviceQualifier, final String fileName) {
        final String relativePathOfNavDir = ".navigation/" + moduleName + "/" + deviceQualifier;
        VirtualFile navFile = baseDir.findFileByRelativePath(relativePathOfNavDir + "/" + fileName);
        if (navFile == null) {
            navFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                public VirtualFile compute() {
                    try {
                        VirtualFile dir = Utilities.mkDirs(baseDir, relativePathOfNavDir);
                        return dir.createChildData(null, fileName);
                    }
                    catch (IOException e) {
                        assert (false);
                        return null;
                    }
                }
            });
        }
        return navFile;
    }

    @NotNull
    public static Module[] getAndroidModules(Project project) {
        if (project == null) {
            Module[] moduleArray = new Module[]{};
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/Utilities", "getAndroidModules"));
            }
            return moduleArray;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<Module> result = new ArrayList<Module>(modules.length);
        for (Module module : modules) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            result.add(module);
        }
        Module[] moduleArray = result.toArray(new Module[result.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/Utilities", "getAndroidModules"));
        }
        return moduleArray;
    }

    @Nullable
    public static Module findModule(@NotNull Module[] modules, @NotNull String name) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/editors/navigation/Utilities", "findModule"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/navigation/Utilities", "findModule"));
        }
        for (Module module : modules) {
            if (!name.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    public static <I, O> O[] map(I[] a, Function<I, O> f, Class<O> resultType) {
        Object[] result = (Object[])Array.newInstance(resultType, a.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = f.fun(a[i]);
        }
        return result;
    }

    public static <I, O> O[] map(I[] a, Function<I, O> f) {
        try {
            Class<?> type = f.getClass().getMethod("fun", a.getClass().getComponentType()).getReturnType();
            return Utilities.map(a, f, type);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Graphics2D createLineGraphics(Graphics g, int lineWidth) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setColor(TRANSITION_LINE_COLOR);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setStroke(new BasicStroke(lineWidth));
        return g2D;
    }

    static Rectangle getCorner(Point a, int cornerDiameter) {
        int cornerRadius = cornerDiameter / 2;
        return new Rectangle(a.x - cornerRadius, a.y - cornerRadius, cornerDiameter, cornerDiameter);
    }

    static void drawLine(Graphics g, Point a, Point b) {
        g.drawLine(a.x, a.y, b.x, b.y);
    }

    static void drawArrow(Graphics g, Point a, Point b, int lineWidth) {
        Utilities.drawArrow(g, a.x, a.y, b.x, b.y, lineWidth);
    }

    static void drawRectangle(Graphics g, Rectangle r) {
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private static int x1(Rectangle src) {
        return src.x;
    }

    private static int x2(Rectangle dst) {
        return dst.x + dst.width;
    }

    private static int y1(Rectangle src) {
        return src.y;
    }

    private static int y2(Rectangle dst) {
        return dst.y + dst.height;
    }

    private static int bound(int i, int min, int max) {
        return i < min ? min : (i > max ? max : i);
    }

    private static boolean overlaps(int min1, int max1, int min2, int max2) {
        return max1 >= min2 && max2 >= min1;
    }

    static Line getMidLine(Rectangle src, Rectangle dst) {
        boolean horizontal;
        boolean xOverlap = Utilities.overlaps(Utilities.x1(src), Utilities.x2(src), Utilities.x1(dst), Utilities.x2(dst));
        boolean yOverlap = Utilities.overlaps(Utilities.y1(src), Utilities.y2(src), Utilities.y1(dst), Utilities.y2(dst));
        int dx = Math.min(Math.abs(Utilities.x1(src) - Utilities.x2(dst)), Math.abs(Utilities.x1(dst) - Utilities.x2(src)));
        int dy = Math.min(Math.abs(Utilities.y1(src) - Utilities.y2(dst)), Math.abs(Utilities.y1(dst) - Utilities.y2(src)));
        boolean bl = xOverlap ? (yOverlap ? dx >= dy : false) : (yOverlap ? true : (horizontal = dx >= dy));
        int middle = horizontal ? (Utilities.x1(src) - Utilities.x2(dst) > 0 ? (Utilities.x2(dst) + Utilities.x1(src)) / 2 : (Utilities.x2(src) + Utilities.x1(dst)) / 2) : (Utilities.y1(src) - Utilities.y2(dst) > 0 ? (Utilities.y2(dst) + Utilities.y1(src)) / 2 : (Utilities.y2(src) + Utilities.y1(dst)) / 2);
        Point midSrc = Utilities.centre(src);
        Point a = horizontal ? new Point(middle, midSrc.y) : new Point(midSrc.x, middle);
        Point b = horizontal ? new Point(middle, Utilities.bound(midSrc.y, Utilities.y1(dst), Utilities.y2(dst))) : new Point(Utilities.bound(midSrc.x, Utilities.x1(dst), Utilities.x2(dst)), middle);
        return new Line(a, b, horizontal);
    }

    static class Line {
        public final Point a;
        public final Point b;
        public final boolean horizontal;

        Line(Point a, Point b, boolean horizontal) {
            this.a = a;
            this.b = b;
            this.horizontal = horizontal;
        }

        Point project(Point p) {
            return this.horizontal ? new Point(this.a.x, p.y) : new Point(p.x, this.a.y);
        }
    }
}

