/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final Project myProject;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/ProjectSyncStatusNotificationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/ProjectSyncStatusNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            return null;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (syncState.isSyncInProgress()) {
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText("Gradle project sync in progress...");
            return panel;
        }
        if (Projects.lastGradleSyncFailed(this.myProject)) {
            return new ProjectImportFailedNotificationPanel();
        }
        ThreeState gradleSyncNeeded = syncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return new StaleGradleModelNotificationPanel();
        }
        return null;
    }

    private class ProjectImportFailedNotificationPanel
    extends EditorNotificationPanel {
        ProjectImportFailedNotificationPanel() {
            this.setText("Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.");
            this.createActionLabel("Try Again", new Runnable(){

                @Override
                public void run() {
                    GradleProjectImporter.getInstance().requestProjectSync(ProjectSyncStatusNotificationProvider.this.myProject, null);
                }
            });
            this.createActionLabel("Open 'Messages' View", new Runnable(){

                @Override
                public void run() {
                    ExternalSystemNotificationManager.getInstance((Project)ProjectSyncStatusNotificationProvider.this.myProject).openMessageView(GradleConstants.SYSTEM_ID, NotificationSource.PROJECT_SYNC);
                }
            });
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), new Runnable(){

                @Override
                public void run() {
                    File logFile = new File(PathManager.getLogPath(), "idea.log");
                    ShowFilePathAction.openFile((File)logFile);
                }
            });
        }
    }

    private class StaleGradleModelNotificationPanel
    extends EditorNotificationPanel {
        StaleGradleModelNotificationPanel() {
            this.setText("Gradle files have changed since last project sync. A project sync may be necessary for the IDE to work properly.");
            this.createActionLabel("Sync Now", new Runnable(){

                @Override
                public void run() {
                    GradleProjectImporter.getInstance().requestProjectSync(ProjectSyncStatusNotificationProvider.this.myProject, null);
                }
            });
        }
    }
}

