/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinLayoutDefinition {
    static final Pattern ourQuerySeparator = Pattern.compile("\\.");
    static final Pattern ourWhitespacePattern = Pattern.compile("\\s+");
    private Map<String, String> myProperties = Maps.newHashMap();
    private Map<String, SkinLayoutDefinition> myChildren = Maps.newHashMap();

    @Nullable
    public static SkinLayoutDefinition parseFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/avdmanager/SkinLayoutDefinition", "parseFile"));
        }
        String contents = TemplateUtils.readTextFile(file);
        if (contents == null) {
            return null;
        }
        return SkinLayoutDefinition.loadFromTokens(Splitter.on((Pattern)ourWhitespacePattern).omitEmptyStrings().trimResults().split((CharSequence)contents).iterator());
    }

    static SkinLayoutDefinition loadFromTokens(Iterator<String> tokens) {
        String key;
        SkinLayoutDefinition definition = new SkinLayoutDefinition();
        while (tokens.hasNext() && !(key = tokens.next()).equals("}")) {
            String value = tokens.next();
            if (value.equals("{")) {
                definition.myChildren.put(key, SkinLayoutDefinition.loadFromTokens(tokens));
                continue;
            }
            definition.myProperties.put(key, value);
        }
        return definition;
    }

    private SkinLayoutDefinition() {
    }

    @Nullable
    public String get(@NotNull String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryString", "com/android/tools/idea/avdmanager/SkinLayoutDefinition", "get"));
        }
        return this.get(Splitter.on((Pattern)ourQuerySeparator).split((CharSequence)queryString).iterator());
    }

    @Nullable
    private String get(@NotNull Iterator<String> queryIterator) {
        if (queryIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryIterator", "com/android/tools/idea/avdmanager/SkinLayoutDefinition", "get"));
        }
        if (!queryIterator.hasNext()) {
            return null;
        }
        String key = queryIterator.next();
        if (!queryIterator.hasNext()) {
            return this.myProperties.get(key);
        }
        SkinLayoutDefinition child = this.myChildren.get(key);
        if (child != null) {
            return child.get(queryIterator);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.makeString(sb, 1);
        return sb.toString();
    }

    private void makeString(@NotNull StringBuilder sb, int depth) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/android/tools/idea/avdmanager/SkinLayoutDefinition", "makeString"));
        }
        sb.append("{\n");
        for (String key : this.myProperties.keySet()) {
            SkinLayoutDefinition.appendSpace(sb, depth);
            sb.append(key);
            sb.append("    ");
            sb.append(this.myProperties.get(key));
            sb.append("\n");
        }
        for (String key : this.myChildren.keySet()) {
            SkinLayoutDefinition.appendSpace(sb, depth);
            sb.append(key);
            sb.append("    ");
            this.myChildren.get(key).makeString(sb, depth + 1);
        }
        SkinLayoutDefinition.appendSpace(sb, depth - 1);
        sb.append("}\n");
    }

    private static void appendSpace(@NotNull StringBuilder sb, int depth) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/android/tools/idea/avdmanager/SkinLayoutDefinition", "appendSpace"));
        }
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
    }
}

