/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class DeleteAvdAction
extends AvdUiAction {
    private static final Logger LOG = Logger.getInstance(DeleteAvdAction.class);

    public DeleteAvdAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "Delete", "Delete this AVD", AllIcons.Actions.Delete);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        AvdInfo info = this.getAvdInfo();
        if (info == null) {
            return;
        }
        if (connection.isAvdRunning(info)) {
            JOptionPane.showMessageDialog(null, "The selected AVD is currently running in the Emulator. Please exit the emulator instance and try deleting again.", "Cannot Delete A Running AVD", 0);
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Do you really want to delete AVD " + info.getName() + "?", "Confirm Deletion", 0);
        if (result == 0) {
            connection.deleteAvd(info);
            this.refreshAvds();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

