/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.SystemImageList;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.android.tools.idea.wizard.DynamicWizardStepWithDescription;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSystemImageStep
extends DynamicWizardStepWithDescription
implements SystemImageList.SystemImageSelectionListener {
    private SystemImageList mySystemImageList;
    private JPanel myPanel;
    private SystemImagePreview mySystemImagePreview;
    private Device myCurrentDevice;
    private Project myProject;

    public ChooseSystemImageStep(@Nullable Project project, @Nullable Disposable parentDisposable) {
        super(parentDisposable);
        this.$$$setupUI$$$();
        this.mySystemImageList.addSelectionListener(this);
        Predicate<AvdWizardConstants.SystemImageDescription> filter = new Predicate<AvdWizardConstants.SystemImageDescription>(){

            public boolean apply(AvdWizardConstants.SystemImageDescription input) {
                return ChooseSystemImageStep.systemImageMatchesDevice(input, ChooseSystemImageStep.this.myCurrentDevice);
            }
        };
        this.mySystemImageList.setFilter(filter);
        this.mySystemImageList.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        this.setBodyComponent(this.myPanel);
    }

    public static boolean systemImageMatchesDevice(AvdWizardConstants.SystemImageDescription image, Device device) {
        if (device == null || image == null) {
            return false;
        }
        String deviceTagId = device.getTagId();
        IdDisplay inputTag = image.getTag();
        if (inputTag == null) {
            return true;
        }
        if (deviceTagId == null || deviceTagId.equals(SystemImage.DEFAULT_TAG.getId())) {
            return inputTag.getId().equals(SystemImage.DEFAULT_TAG.getId()) || !inputTag.equals((Object)AvdWizardConstants.TV_TAG) && !inputTag.equals((Object)AvdWizardConstants.WEAR_TAG);
        }
        return deviceTagId.equals(inputTag.getId());
    }

    @Override
    public boolean validate() {
        return this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY) != null;
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.getNotNull(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false) == false || !this.myState.containsKey(AvdWizardConstants.SYSTEM_IMAGE_KEY);
    }

    @Override
    public void onEnterStep() {
        String oldTag;
        super.onEnterStep();
        Device newDevice = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        String newTag = newDevice == null ? null : newDevice.getTagId();
        String string = oldTag = this.myCurrentDevice == null ? null : this.myCurrentDevice.getTagId();
        if (!Objects.equal((Object)newTag, (Object)oldTag)) {
            this.myState.remove(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        }
        this.myCurrentDevice = newDevice;
        AvdWizardConstants.SystemImageDescription selectedImage = this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        this.mySystemImageList.refreshLocalImagesSynchronously();
        if (selectedImage != null) {
            this.mySystemImageList.setSelectedImage(selectedImage);
        } else {
            this.mySystemImageList.selectDefaultImage();
        }
        this.mySystemImageList.refreshImages(false);
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose System Image Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getStepName"));
        }
        return "Choose System Image Step";
    }

    @Override
    public void onSystemImageSelected(@Nullable AvdWizardConstants.SystemImageDescription systemImage) {
        this.mySystemImagePreview.setImage(systemImage);
        this.myState.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, systemImage);
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("System Image" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getStepTitle"));
        }
        return "System Image";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Select a system image";
    }

    private void createUIComponents() {
        this.mySystemImageList = new SystemImageList(this.myProject);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SystemImagePreview systemImagePreview;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        SystemImageList systemImageList = this.mySystemImageList;
        jPanel.add((Component)systemImageList, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.mySystemImagePreview = systemImagePreview = new SystemImagePreview();
        JComponent jComponent = systemImagePreview.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 3, null, new Dimension(360, -1), new Dimension(360, -1)));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

