/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdConfigurationPath;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.ddms.screenshot.DeviceArtDescriptor;
import com.android.tools.idea.wizard.DialogWrapperHost;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.SingleStepPath;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdEditWizard
extends DynamicWizard {
    @Nullable
    private final AvdInfo myAvdInfo;
    private final boolean myForceCreate;

    public AvdEditWizard(@Nullable Project project, @Nullable Module module, @Nullable AvdInfo avdInfo, boolean forceCreate) {
        super(project, module, "AvdEditWizard", new DialogWrapperHost(project, DialogWrapper.IdeModalityType.PROJECT));
        this.myAvdInfo = avdInfo;
        this.myForceCreate = forceCreate;
        this.setTitle("Virtual Device Configuration");
    }

    @Override
    public void init() {
        if (this.myAvdInfo != null) {
            this.fillExistingInfo(this.myAvdInfo);
            if (this.myForceCreate) {
                String displayName = (String)this.myAvdInfo.getProperties().get(AvdWizardConstants.DISPLAY_NAME_KEY.name);
                this.getState().put(AvdWizardConstants.DISPLAY_NAME_KEY, String.format("Copy of %1$s", displayName));
            }
        } else {
            this.initDefaultInfo();
        }
        this.addPath(new AvdConfigurationPath(this.getDisposable()));
        ConfigureAvdOptionsStep configStep = new ConfigureAvdOptionsStep(this.getDisposable());
        this.addPath(new SingleStepPath(configStep));
        super.init();
        if (this.myForceCreate && this.myAvdInfo != null) {
            this.getState().put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false);
        }
    }

    private void initDefaultInfo() {
        ScopedStateStore state = this.getState();
        state.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdWizardConstants.DEFAULT_SCALE);
        state.put(AvdWizardConstants.NETWORK_SPEED_KEY, "full");
        state.put(AvdWizardConstants.NETWORK_LATENCY_KEY, "none");
        state.put(AvdWizardConstants.FRONT_CAMERA_KEY, "none");
        state.put(AvdWizardConstants.BACK_CAMERA_KEY, "none");
        state.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdWizardConstants.DEFAULT_INTERNAL_STORAGE);
        state.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false);
        state.put(AvdWizardConstants.USE_HOST_GPU_KEY, true);
        state.put(AvdWizardConstants.DISPLAY_SD_SIZE_KEY, new Storage(100L, Storage.Unit.MiB));
        state.put(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, false);
    }

    private void fillExistingInfo(@NotNull AvdInfo avdInfo) {
        File skinFile;
        String skinPath;
        ISystemImage selectedImage;
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdEditWizard", "fillExistingInfo"));
        }
        ScopedStateStore state = this.getState();
        List<Device> devices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        Device selectedDevice = null;
        String manufacturer = avdInfo.getDeviceManufacturer();
        String deviceId = (String)avdInfo.getProperties().get("hw.device.name");
        for (Device device : devices) {
            if (!manufacturer.equals(device.getManufacturer()) || !deviceId.equals(device.getId())) continue;
            selectedDevice = device;
            break;
        }
        state.put(AvdWizardConstants.DEVICE_DEFINITION_KEY, selectedDevice);
        IAndroidTarget target = avdInfo.getTarget();
        if (target != null && (selectedImage = target.getSystemImage(avdInfo.getTag(), avdInfo.getAbiType())) != null) {
            AvdWizardConstants.SystemImageDescription systemImageDescription = new AvdWizardConstants.SystemImageDescription(target, selectedImage);
            state.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, systemImageDescription);
        }
        Map properties = avdInfo.getProperties();
        state.put(AvdWizardConstants.RAM_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.RAM_STORAGE_KEY.name)));
        state.put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.VM_HEAP_STORAGE_KEY.name)));
        state.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.INTERNAL_STORAGE_KEY.name)));
        String sdCardLocation = null;
        if (properties.get(AvdWizardConstants.EXISTING_SD_LOCATION.name) != null) {
            sdCardLocation = (String)properties.get(AvdWizardConstants.EXISTING_SD_LOCATION.name);
        } else if (properties.get(AvdWizardConstants.SD_CARD_STORAGE_KEY.name) != null) {
            sdCardLocation = FileUtil.join((String[])new String[]{avdInfo.getDataFolderPath(), "sdcard.img"});
        }
        state.put(AvdWizardConstants.EXISTING_SD_LOCATION, sdCardLocation);
        String dataFolderPath = avdInfo.getDataFolderPath();
        File sdLocationFile = null;
        if (sdCardLocation != null) {
            sdLocationFile = new File(sdCardLocation);
        }
        if (sdLocationFile != null && Objects.equal((Object)sdLocationFile.getParent(), (Object)dataFolderPath)) {
            File sdFile = new File(sdCardLocation);
            Storage sdCardSize = new Storage(sdFile.length());
            this.myState.put(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, false);
            this.myState.put(AvdWizardConstants.SD_CARD_STORAGE_KEY, sdCardSize);
            this.myState.put(AvdWizardConstants.DISPLAY_SD_SIZE_KEY, sdCardSize);
        } else {
            this.myState.put(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, true);
            this.myState.put(AvdWizardConstants.DISPLAY_SD_LOCATION_KEY, sdCardLocation);
        }
        String scale = (String)properties.get(AvdWizardConstants.SCALE_SELECTION_KEY.name);
        if (scale != null) {
            state.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdScaleFactor.findByValue(scale));
        }
        state.put(AvdWizardConstants.USE_HOST_GPU_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.USE_HOST_GPU_KEY.name)));
        state.put(AvdWizardConstants.USE_SNAPSHOT_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.USE_SNAPSHOT_KEY.name)));
        state.put(AvdWizardConstants.FRONT_CAMERA_KEY, properties.get(AvdWizardConstants.FRONT_CAMERA_KEY.name));
        state.put(AvdWizardConstants.BACK_CAMERA_KEY, properties.get(AvdWizardConstants.BACK_CAMERA_KEY.name));
        state.put(AvdWizardConstants.NETWORK_LATENCY_KEY, properties.get(AvdWizardConstants.NETWORK_LATENCY_KEY.name));
        state.put(AvdWizardConstants.NETWORK_SPEED_KEY, properties.get(AvdWizardConstants.NETWORK_SPEED_KEY.name));
        state.put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY.name)));
        state.put(AvdWizardConstants.DISPLAY_NAME_KEY, AvdManagerConnection.getAvdDisplayName(avdInfo));
        String orientation = (String)properties.get("hw.initialOrientation");
        if (orientation != null) {
            state.put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, ScreenOrientation.getByShortDisplayName((String)orientation));
        }
        if ((skinPath = (String)properties.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY.name)) != null && (skinFile = new File(skinPath)).isDirectory()) {
            state.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, skinFile);
        }
        state.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, true);
    }

    @Nullable
    private static Storage getStorageFromIni(String iniString) {
        if (iniString == null) {
            return null;
        }
        String numString = iniString.substring(0, iniString.length() - 1);
        char unitChar = iniString.charAt(iniString.length() - 1);
        Storage.Unit selectedUnit = null;
        for (Storage.Unit u : Storage.Unit.values()) {
            if (u.toString().charAt(0) != unitChar) continue;
            selectedUnit = u;
            break;
        }
        if (selectedUnit == null) {
            selectedUnit = Storage.Unit.MiB;
            numString = iniString;
        }
        try {
            long numLong = Long.parseLong(numString);
            return new Storage(numLong, selectedUnit);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void performFinishingActions() {
        AvdEditWizard.createAvd(this.myAvdInfo, this.getState(), this.myForceCreate);
    }

    @Nullable
    public static AvdInfo createAvd(@Nullable AvdInfo avdInfo, @NotNull ScopedStateStore state, boolean forceCreate) {
        int newApiLevel;
        int oldApiLevel;
        IAndroidTarget target;
        boolean hasSdCard;
        boolean useExisting;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/AvdEditWizard", "createAvd"));
        }
        Device device = state.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        assert (device != null);
        AvdWizardConstants.SystemImageDescription systemImageDescription = state.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        assert (systemImageDescription != null);
        ScreenOrientation orientation = state.get(AvdWizardConstants.DEFAULT_ORIENTATION_KEY);
        if (orientation == null) {
            orientation = device.getDefaultState().getOrientation();
        }
        Map hardwareProperties = DeviceManager.getHardwareProperties((Device)device);
        Map userEditedProperties = state.flatten();
        String sdCard = null;
        Boolean useExternalSdCard = state.get(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY);
        boolean bl = useExisting = useExternalSdCard != null && useExternalSdCard != false;
        if (!useExisting && Objects.equal((Object)state.get(AvdWizardConstants.SD_CARD_STORAGE_KEY), (Object)state.get(AvdWizardConstants.DISPLAY_SD_SIZE_KEY))) {
            useExisting = true;
        }
        if (!useExisting) {
            userEditedProperties.remove(AvdWizardConstants.EXISTING_SD_LOCATION.name);
            Storage storage = state.get(AvdWizardConstants.DISPLAY_SD_SIZE_KEY);
            state.put(AvdWizardConstants.SD_CARD_STORAGE_KEY, storage);
            if (storage != null) {
                sdCard = AvdEditWizard.toIniString(storage, false);
            }
            hasSdCard = storage != null && storage.getSize() > 0L;
        } else {
            sdCard = state.get(AvdWizardConstants.DISPLAY_SD_LOCATION_KEY);
            state.put(AvdWizardConstants.EXISTING_SD_LOCATION, sdCard);
            userEditedProperties.remove(AvdWizardConstants.SD_CARD_STORAGE_KEY.name);
            assert (sdCard != null);
            hasSdCard = true;
            hardwareProperties.put("hw.sdCard", AvdEditWizard.toIniString(true));
        }
        hardwareProperties.put("hw.sdCard", AvdEditWizard.toIniString(hasSdCard));
        userEditedProperties = Maps.filterEntries(userEditedProperties, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return !input.getKey().startsWith("AvdManager.WizardOnly.") && input.getValue() != null;
            }
        });
        hardwareProperties.putAll(Maps.transformEntries((Map)userEditedProperties, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Object, String>(){

            public String transformEntry(String key, Object value) {
                if (value instanceof Storage) {
                    if (key.equals(AvdWizardConstants.RAM_STORAGE_KEY.name) || key.equals(AvdWizardConstants.VM_HEAP_STORAGE_KEY.name)) {
                        return AvdEditWizard.toIniString((Storage)value, true);
                    }
                    return AvdEditWizard.toIniString((Storage)value, false);
                }
                if (value instanceof Boolean) {
                    return AvdEditWizard.toIniString((Boolean)value);
                }
                if (value instanceof AvdScaleFactor) {
                    return AvdEditWizard.toIniString((AvdScaleFactor)((Object)value));
                }
                if (value instanceof File) {
                    return AvdEditWizard.toIniString((File)value);
                }
                if (value instanceof Double) {
                    return AvdEditWizard.toIniString((Double)value);
                }
                return value.toString();
            }
        }));
        File skinFile = state.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        if (skinFile == null) {
            skinFile = AvdEditWizard.resolveSkinPath(device.getDefaultHardware().getSkinFile(), systemImageDescription);
        }
        if (!hardwareProperties.containsKey("skin.dynamic")) {
            hardwareProperties.put("skin.dynamic", AvdEditWizard.toIniString(false));
        }
        if (!hardwareProperties.containsKey("hw.keyboard")) {
            hardwareProperties.put("hw.keyboard", AvdEditWizard.toIniString(false));
        }
        boolean isCircular = DeviceDefinitionPreview.isCircular(device);
        String avdName = state.get(AvdWizardConstants.AVD_ID_KEY);
        if (avdName == null || avdName.isEmpty()) {
            avdName = AvdEditWizard.calculateAvdName(avdInfo, hardwareProperties, device, forceCreate);
        }
        if (avdInfo != null && !forceCreate && (target = avdInfo.getTarget()) != null && (oldApiLevel = target.getVersion().getApiLevel()) > (newApiLevel = systemImageDescription.getVersion().getApiLevel())) {
            String message = String.format(Locale.getDefault(), "You are about to downgrade %1$s from API level %2$d to API level %3$d. This requires a wipe of the userdata partition of the AVD. Do you wish to continue with the data wipe?", avdName, oldApiLevel, newApiLevel);
            int result = JOptionPane.showConfirmDialog(null, message, "Confirm Data Wipe", 0);
            if (result == 0) {
                AvdManagerConnection.getDefaultAvdManagerConnection().wipeUserData(avdInfo);
            } else {
                return null;
            }
        }
        if (forceCreate) {
            avdInfo = null;
        }
        return AvdEditWizard.createWithProgress(avdInfo, device, systemImageDescription, orientation, hardwareProperties, sdCard, skinFile, isCircular, avdName);
    }

    @Nullable
    private static AvdInfo createWithProgress(final @Nullable AvdInfo avdInfo, final @NotNull Device device, final @NotNull AvdWizardConstants.SystemImageDescription systemImageDescription, final @NotNull ScreenOrientation orientation, final @NotNull Map<String, String> hardwareProperties, final @Nullable String sdCard, final @Nullable File skinFile, final boolean isCircular, final @NotNull String avdName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdEditWizard", "createWithProgress"));
        }
        if (systemImageDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemImageDescription", "com/android/tools/idea/avdmanager/AvdEditWizard", "createWithProgress"));
        }
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/avdmanager/AvdEditWizard", "createWithProgress"));
        }
        if (hardwareProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareProperties", "com/android/tools/idea/avdmanager/AvdEditWizard", "createWithProgress"));
        }
        if (avdName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdName", "com/android/tools/idea/avdmanager/AvdEditWizard", "createWithProgress"));
        }
        final AtomicReference infoReference = new AtomicReference();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
                infoReference.set(connection.createOrUpdateAvd(avdInfo, avdName, device, systemImageDescription, orientation, isCircular, sdCard, skinFile, hardwareProperties, false));
            }
        }, "Creating/Updating AVD...", false, null, null);
        return (AvdInfo)infoReference.get();
    }

    @Nullable
    public static File resolveSkinPath(@Nullable File path, @Nullable AvdWizardConstants.SystemImageDescription image) {
        if (path == null || path.getPath().isEmpty() || path.equals(AvdWizardConstants.NO_SKIN)) {
            return path;
        }
        if (!path.isAbsolute()) {
            File resourcePath;
            File resourceDir;
            if (image != null) {
                File[] skins;
                for (File skin : skins = image.getSkins()) {
                    if (!skin.getPath().endsWith("/" + path.getPath())) continue;
                    return skin;
                }
            }
            if ((resourceDir = DeviceArtDescriptor.getBundledDescriptorsFolder()) != null && (resourcePath = new File(resourceDir, path.getPath())).exists()) {
                return resourcePath;
            }
        }
        return path;
    }

    @NotNull
    private static String toIniString(@NotNull Double value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = String.format(Locale.US, "%f", value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull File value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = value.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull AvdScaleFactor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = value.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String calculateAvdName(@Nullable AvdInfo avdInfo, @NotNull Map<String, String> hardwareProperties, @NotNull Device device, boolean forceCreate) {
        if (hardwareProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareProperties", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        if (avdInfo != null && !forceCreate) {
            String string = avdInfo.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
            }
            return string;
        }
        String candidateBase = hardwareProperties.get("avd.ini.displayname");
        if (candidateBase == null || candidateBase.isEmpty()) {
            String deviceName = device.getDisplayName().replace(' ', '_');
            String manufacturer = device.getManufacturer().replace(' ', '_');
            candidateBase = String.format("AVD_for_%1$s_by_%2$s", deviceName, manufacturer);
        }
        String string = AvdEditWizard.cleanAvdName(AvdManagerConnection.getDefaultAvdManagerConnection(), candidateBase, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        return string;
    }

    public static String cleanAvdName(@NotNull AvdManagerConnection connection, @NotNull String candidateBase, boolean uniquify) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/idea/avdmanager/AvdEditWizard", "cleanAvdName"));
        }
        if (candidateBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBase", "com/android/tools/idea/avdmanager/AvdEditWizard", "cleanAvdName"));
        }
        if ((candidateBase = candidateBase.replaceAll("[^0-9a-zA-Z_-]+", " ").trim().replaceAll("[ _]+", "_")).isEmpty()) {
            candidateBase = "myavd";
        }
        String candidate = candidateBase;
        if (uniquify) {
            int i = 1;
            while (connection.avdExists(candidate)) {
                candidate = String.format("%1$s_%2$d", candidateBase, i++);
            }
        }
        return candidate;
    }

    @NotNull
    public static String toIniString(@NotNull Storage storage, boolean convertToMb) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        Storage.Unit unit = convertToMb ? Storage.Unit.MiB : storage.getAppropriateUnits();
        String unitString = convertToMb ? "" : unit.toString().substring(0, 1);
        String string = String.format("%1$d%2$s", storage.getSizeAsUnit(unit), unitString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull Boolean b) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = b != false ? "yes" : "no";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    private static boolean fromIniString(@Nullable String s) {
        return "yes".equals(s);
    }

    @Override
    protected String getWizardActionDescription() {
        return "Create/Edit an Android Virtual Device";
    }
}

