/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.eclipse.AdtImportProvider;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.project.AdtModuleImporter;
import com.android.tools.idea.gradle.project.GradleModuleImporter;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.google.common.collect.Lists;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportProjectAction
extends AnAction {
    @NonNls
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";
    private static final Logger LOG = Logger.getInstance(AndroidImportProjectAction.class);
    private static final String WIZARD_TITLE = "Select Eclipse or Gradle Project to Import";
    private static final String WIZARD_DESCRIPTION = "Select your Eclipse project folder, build.gradle or settings.gradle";

    public AndroidImportProjectAction() {
        super("Import Project...");
    }

    public void actionPerformed(AnActionEvent e) {
        try {
            AddModuleWizard wizard = this.selectFileAndCreateWizard();
            if (wizard != null && wizard.getStepCount() > 0) {
                if (!wizard.showAndGet()) {
                    return;
                }
                NewProjectUtil.createFromWizard((AbstractProjectWizard)wizard, null);
            }
        }
        catch (IOException exception) {
            this.handleImportException(e.getProject(), exception);
        }
        catch (ConfigurationException exception) {
            this.handleImportException(e.getProject(), (Exception)((Object)exception));
        }
    }

    private void handleImportException(@Nullable Project project, @NotNull Exception e1) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/android/tools/idea/actions/AndroidImportProjectAction", "handleImportException"));
        }
        String message = String.format("Project import failed: %s", e1.getMessage());
        Messages.showErrorDialog((Project)project, (String)message, (String)"Import Project");
        LOG.error((Throwable)e1);
    }

    @NotNull
    protected FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, false){
            FileChooserDescriptor myDelegate;
            {
                this.myDelegate = new OpenProjectFileChooserDescriptor(true);
            }

            public Icon getIcon(VirtualFile file) {
                Icon icon = this.myDelegate.getIcon(file);
                return icon == null ? super.getIcon(file) : icon;
            }
        };
        descriptor.setHideIgnored(false);
        descriptor.setTitle(WIZARD_TITLE);
        descriptor.setDescription(WIZARD_DESCRIPTION);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/AndroidImportProjectAction", "createFileChooserDescriptor"));
        }
        return fileChooserDescriptor;
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard() throws IOException, ConfigurationException {
        return this.selectFileAndCreateWizard(this.createFileChooserDescriptor());
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard(@NotNull FileChooserDescriptor descriptor) throws IOException, ConfigurationException {
        VirtualFile[] files;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/actions/AndroidImportProjectAction", "selectFileAndCreateWizard"));
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, null, null);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(null, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return this.createImportWizard(file);
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile file) throws IOException, ConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/AndroidImportProjectAction", "createImportWizard"));
        }
        VirtualFile target = ProjectImportUtil.findImportTarget(file);
        if (target == null) {
            return null;
        }
        VirtualFile targetDir = target.isDirectory() ? target : target.getParent();
        File targetDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)targetDir);
        if (AdtModuleImporter.isAdtProjectLocation(file)) {
            AndroidImportProjectAction.importAdtProject(file);
        } else if (GradleImport.isEclipseProjectDir(targetDirFile) && targetDir.findChild("build.gradle") == null && !ApplicationManager.getApplication().isUnitTestMode()) {
            String message = String.format("%1$s is an Eclipse project, but not an Android Eclipse project.\n\nPlease select the directory of an Android Eclipse project(which for example will contain\nan AndroidManifest.xml file) and try again.", file.getPath());
            Messages.showErrorDialog((String)message, (String)"Import Project");
        } else if (GradleModuleImporter.isGradleProject(target)) {
            GradleProjectImporter gradleImporter = GradleProjectImporter.getInstance();
            gradleImporter.importProject(file);
        } else {
            return AndroidImportProjectAction.importWithExtensions(file);
        }
        return null;
    }

    @Nullable
    private static AddModuleWizard importWithExtensions(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/AndroidImportProjectAction", "importWithExtensions"));
        }
        List<ProjectImportProvider> available = AndroidImportProjectAction.getImportProvidersForTarget(file);
        if (available.isEmpty()) {
            Messages.showInfoMessage((Project)null, (String)("Cannot import anything from " + file.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? available.get(0).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath((VirtualFile)file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[available.size()]);
        return new AddModuleWizard(null, path, availableProviders);
    }

    @NotNull
    private static List<ProjectImportProvider> getImportProvidersForTarget(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/AndroidImportProjectAction", "getImportProvidersForTarget"));
        }
        VirtualFile target = ProjectImportUtil.findImportTarget(file);
        if (target == null) {
            List<ProjectImportProvider> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/AndroidImportProjectAction", "getImportProvidersForTarget"));
            }
            return list;
        }
        ArrayList available = Lists.newArrayList();
        for (ProjectImportProvider provider : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!provider.canImport(target, null)) continue;
            available.add(provider);
        }
        ArrayList arrayList = available;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/AndroidImportProjectAction", "getImportProvidersForTarget"));
        }
        return arrayList;
    }

    private static void importAdtProject(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/AndroidImportProjectAction", "importAdtProject"));
        }
        AdtImportProvider adtImportProvider = new AdtImportProvider(true);
        AddModuleWizard wizard = new AddModuleWizard(null, ProjectImportProvider.getDefaultPath((VirtualFile)file), new ProjectImportProvider[]{adtImportProvider});
        if (wizard.showAndGet()) {
            try {
                AndroidImportProjectAction.doCreate(wizard);
            }
            catch (IOException e) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)e.getMessage(), (String)"Project Initialization Failed");
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCreate(@NotNull AddModuleWizard wizard) throws IOException {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/actions/AndroidImportProjectAction", "doCreate"));
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            File projectFilePath = new File(wizard.getNewProjectFilePath());
            File projectDirPath = projectFilePath.isDirectory() ? projectFilePath : projectFilePath.getParentFile();
            LOG.assertTrue(projectDirPath != null, (Object)("Cannot create project in '" + projectFilePath + "': no parent file exists"));
            FileUtil.ensureExists((File)projectDirPath);
            if (StorageScheme.DIRECTORY_BASED == wizard.getStorageScheme()) {
                File ideaDirPath = new File(projectDirPath, ".idea");
                FileUtil.ensureExists((File)ideaDirPath);
            }
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            Project project = projectManager.newProject(wizard.getProjectName(), projectDirPath.getPath(), true, false);
            if (project == null) {
                return;
            }
            if (!unitTestMode) {
                project.save();
            }
            if (projectBuilder != null) {
                if (!projectBuilder.validate(null, project)) {
                    return;
                }
                projectBuilder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!unitTestMode) {
                project.save();
            }
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }
}

