/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.plugins.xpathView.util.MyPsiUtil;
import org.intellij.plugins.xpathView.util.Namespace;

public class NamespaceCollector
extends XmlRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.xpathView.util.NamespaceCollector");
    private final Set<Namespace> namespaces = new LinkedHashSet<Namespace>();
    private final Set<QName> elements = new HashSet<QName>(64);
    private final Set<QName> attributes = new HashSet<QName>(64);

    private NamespaceCollector() {
    }

    public Set<Namespace> getNamespaces() {
        return this.namespaces;
    }

    public void visitXmlAttribute(XmlAttribute xmlAttribute) {
        if (xmlAttribute.isNamespaceDeclaration()) {
            LOG.debug("Namespace: " + xmlAttribute.getLocalName() + " => " + xmlAttribute.getValue());
            this.addNamespace(xmlAttribute.getLocalName(), xmlAttribute.getValue());
        } else {
            this.addAttribute(xmlAttribute);
        }
    }

    public void visitXmlTag(XmlTag tag) {
        Map namespaceDeclarations = tag.getLocalNamespaceDeclarations();
        Set localPrefixes = namespaceDeclarations.keySet();
        for (String prefix : localPrefixes) {
            this.addNamespace("xmlns".equals(prefix) ? "" : prefix, (String)namespaceDeclarations.get(prefix));
        }
        this.addElement(tag);
        super.visitXmlTag(tag);
    }

    private void addAttribute(XmlAttribute xmlAttribute) {
        String namespace = xmlAttribute.getNamespace();
        String localName = xmlAttribute.getLocalName();
        String name = xmlAttribute.getName();
        if (name.indexOf(58) == -1) {
            this.attributes.add(new QName("", localName));
        } else {
            this.attributes.add(new QName(namespace, localName));
        }
    }

    private void addElement(XmlTag tag) {
        String prefix;
        String uri = tag.getNamespace();
        if (MyPsiUtil.isInDeclaredNamespace(tag, uri, prefix = tag.getNamespacePrefix())) {
            this.elements.add(new QName(uri, tag.getLocalName(), prefix));
        } else {
            this.elements.add(new QName("", tag.getLocalName(), ""));
        }
    }

    private void addNamespace(String prefix, String value) {
        if (value.length() > 0) {
            Namespace namespace = new Namespace(prefix, value);
            this.namespaces.add(namespace);
        }
    }

    public static Set<Namespace> findAllNamespaces(XmlFile psiFile) {
        NamespaceCollector namespaceCollector = new NamespaceCollector();
        XmlDocument document = psiFile.getDocument();
        if (document != null) {
            document.accept((PsiElementVisitor)namespaceCollector);
        }
        return namespaceCollector.namespaces;
    }

    public static CollectedInfo empty() {
        return new CollectedInfo(Collections.<Namespace>emptySet(), Collections.<QName>emptySet(), Collections.<QName>emptySet());
    }

    public static CollectedInfo collectInfo(XmlFile psiFile) {
        NamespaceCollector namespaceCollector = new NamespaceCollector();
        XmlDocument document = psiFile.getDocument();
        if (document != null) {
            document.accept((PsiElementVisitor)namespaceCollector);
        }
        return new CollectedInfo(namespaceCollector.namespaces, namespaceCollector.elements, namespaceCollector.attributes);
    }

    public static Map<String, String> findNamespaces(XmlFile psiFile) {
        NamespaceCollector namespaceCollector = new NamespaceCollector();
        XmlDocument document = psiFile.getDocument();
        if (document != null) {
            document.accept((PsiElementVisitor)namespaceCollector);
        }
        Set<Namespace> namespaces = namespaceCollector.namespaces;
        return NamespaceCollector.convert(namespaces);
    }

    public static Map<String, String> convert(Collection<Namespace> namespaces) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Namespace namespace : namespaces) {
            if (map.containsKey(namespace.getPrefix())) continue;
            map.put(namespace.getPrefix(), namespace.getUri());
        }
        return map;
    }

    public static class CollectedInfo {
        public final Set<Namespace> namespaces;
        public final Set<QName> elements;
        public final Set<QName> attributes;

        CollectedInfo(Set<Namespace> namespaces, Set<QName> elements, Set<QName> attributes) {
            this.namespaces = Collections.unmodifiableSet(namespaces);
            this.elements = Collections.unmodifiableSet(elements);
            this.attributes = Collections.unmodifiableSet(attributes);
        }
    }
}

