/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import gnu.trove.THashMap;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.lang.xpath.xslt.util.ElementProcessor;
import org.jetbrains.annotations.NotNull;

public final class DeclarationChecker
extends ElementProcessor<XmlTag>
implements PsiElementProcessor<PsiElement> {
    private static final UserDataCache<CachedValue<DeclarationChecker>, XmlFile, Void> CACHE = new UserDataCache<CachedValue<DeclarationChecker>, XmlFile, Void>("CACHE"){

        protected CachedValue<DeclarationChecker> compute(final XmlFile file, Void p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<DeclarationChecker>(){

                public CachedValueProvider.Result<DeclarationChecker> compute() {
                    DeclarationChecker holder = new DeclarationChecker(file);
                    holder.check(file);
                    return CachedValueProvider.Result.create((Object)holder, (Object[])new Object[]{file});
                }
            }, false);
        }
    };
    private final Map<XmlTag, XmlTag> myDuplications = new HashMap<XmlTag, XmlTag>();
    private final Map<XmlTag, XmlTag> myShadows = new HashMap<XmlTag, XmlTag>();
    private State myProcessingState;

    DeclarationChecker(XmlFile file) {
        super(file.getRootTag());
    }

    public boolean execute(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/DeclarationChecker", "execute"));
        }
        if (element instanceof XmlTag) {
            return this.process((XmlTag)element);
        }
        return true;
    }

    @Override
    protected boolean followImport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTemplate(XmlTag t) {
        String n = t.getAttributeValue("name");
        if (n != null) {
            this.myProcessingState.processTemplate(n, t);
        }
        if (!this.isInclude()) {
            this.myProcessingState.enterTemplate();
            try {
                this.processChildren(t);
            }
            finally {
                this.myProcessingState.leaveTemplate();
            }
        }
    }

    @Override
    protected void processVarOrParam(XmlTag t) {
        String n = t.getAttributeValue("name");
        if (n != null) {
            this.myProcessingState.processVariable(n, t);
        }
        this.processChildren(t);
    }

    @Override
    protected boolean shouldContinue() {
        return true;
    }

    public XmlTag getShadowedVariable(XmlTag var) {
        return this.myShadows.get(var);
    }

    public XmlTag getDuplicatedSymbol(XmlTag var) {
        return this.myDuplications.get(var);
    }

    @Override
    protected void processTag(XmlTag tag) {
        if (this.myProcessingState.insideTemplate()) {
            this.processChildren(tag);
        }
    }

    private void processChildren(XmlTag t) {
        XmlTag[] subTags;
        for (XmlTag subTag : subTags = t.getSubTags()) {
            this.process(subTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(XmlFile file) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null) {
            this.myProcessingState = new State();
            try {
                rootTag.processElements((PsiElementProcessor)this, (PsiElement)rootTag);
            }
            finally {
                this.myProcessingState = null;
            }
        }
    }

    public static DeclarationChecker getInstance(XmlFile file) {
        return (DeclarationChecker)((CachedValue)CACHE.get((UserDataHolder)file, null)).getValue();
    }

    final class State {
        private final Map<String, XmlTag> myTemplateDeclarations = new THashMap();
        private final Map<String, XmlTag> myTopLevelVariables = new THashMap();
        private final Map<String, XmlTag> myLocalVariables = new THashMap();
        private Map<String, XmlTag> myVariableDeclarations = this.myTopLevelVariables;

        State() {
        }

        public void enterTemplate() {
            this.myVariableDeclarations = this.myLocalVariables;
        }

        public void leaveTemplate() {
            this.myLocalVariables.clear();
            this.myVariableDeclarations = this.myTopLevelVariables;
        }

        public boolean insideTemplate() {
            return this.myVariableDeclarations == this.myLocalVariables;
        }

        public void processVariable(final String name, XmlTag tag) {
            XmlTag var;
            ResolveUtil.treeWalkUp(new ElementProcessor<XmlTag>(tag){
                boolean myContinue;
                {
                    super(x0);
                    this.myContinue = true;
                }

                @Override
                protected void processTemplate(XmlTag tag) {
                    this.myContinue = false;
                }

                @Override
                protected void processVarOrParam(XmlTag tag) {
                    if (tag != this.myRoot && name.equals(tag.getAttributeValue("name"))) {
                        assert (this.myContinue);
                        if (XsltSupport.getXsltLanguageLevel(tag.getContainingFile()) == XsltChecker.LanguageLevel.V2) {
                            DeclarationChecker.this.myShadows.put(this.myRoot, tag);
                        } else {
                            DeclarationChecker.this.myDuplications.put(this.myRoot, tag);
                        }
                    }
                }

                @Override
                protected boolean shouldContinue() {
                    return this.myContinue;
                }

                @Override
                protected boolean followImport() {
                    return false;
                }
            }, (PsiElement)tag);
            if (this.insideTemplate() && (var = this.myTopLevelVariables.get(name)) != null) {
                DeclarationChecker.this.myShadows.put(tag, var);
            }
            this.myVariableDeclarations.put(name, tag);
        }

        public void processTemplate(String name, XmlTag tag) {
            XmlTag templ = this.myTemplateDeclarations.get(name);
            if (templ != null) {
                DeclarationChecker.this.myDuplications.put(tag, templ);
            }
            this.myTemplateDeclarations.put(name, tag);
        }
    }
}

