/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.completion;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.completion.AxisLookup;
import org.intellij.lang.xpath.completion.FunctionLookup;
import org.intellij.lang.xpath.completion.Lookup;
import org.intellij.lang.xpath.completion.NamespaceLookup;
import org.intellij.lang.xpath.completion.NodeLookup;
import org.intellij.lang.xpath.completion.VariableLookup;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathLocationPath;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariable;

public class CompletionLists {
    public static final String INTELLIJ_IDEA_RULEZ = "IntellijIdeaRulezzz";
    public static final Set<String> NODE_TYPE_FUNCS = new HashSet<String>(Arrays.asList("text", "node", "comment", "processing-instruction"));
    public static final Set<String> NODE_TYPE_FUNCS_V2 = new HashSet<String>(Arrays.asList("text", "node", "comment", "processing-instruction", "attribute", "element", "schema-element", "schema-attribute", "document-node"));
    public static final Set<String> OPERATORS = new HashSet<String>(Arrays.asList("mul", "div", "and", "or"));
    public static final Set<String> AXIS_NAMES = new HashSet<String>(Arrays.asList("ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "namespace", "parent", "preceding", "preceding-sibling", "self"));
    private static final Function<String, Lookup> FUNCTION_MAPPING = new Function<String, Lookup>(){

        public Lookup fun(String s) {
            if (s.equals("processing-instruction")) {
                return new FunctionLookup(s, s + "(pi-target?)");
            }
            return new FunctionLookup(s, s + "()");
        }
    };

    private CompletionLists() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<Lookup> getFunctionCompletions(XPathElement element) {
        String uri;
        XPathFile xpathFile = (XPathFile)element.getContainingFile();
        ContextProvider contextProvider = ContextProvider.getContextProvider((PsiFile)xpathFile);
        NamespaceContext nsContext = contextProvider.getNamespaceContext();
        PrefixedName qn = null;
        if (element instanceof QNameElement) {
            qn = ((QNameElement)element).getQName();
            if (qn != null) {
                QName qName = contextProvider.getQName(qn, element);
                if (qn.getPrefix() != null) {
                    if (qName == null) return Collections.emptySet();
                    uri = qName.getNamespaceURI();
                } else {
                    uri = null;
                }
            } else {
                uri = null;
            }
        } else {
            uri = null;
        }
        Map<Pair<QName, Integer>, ? extends org.intellij.lang.xpath.context.functions.Function> functions = contextProvider.getFunctionContext().getFunctions();
        ArrayList<Lookup> lookups = new ArrayList<Lookup>(functions.size());
        for (Map.Entry<Pair<QName, Integer>, ? extends org.intellij.lang.xpath.context.functions.Function> entry : functions.entrySet()) {
            String p;
            org.intellij.lang.xpath.context.functions.Function functionDecl = entry.getValue();
            QName f = (QName)entry.getKey().first;
            if (nsContext != null) {
                String prefixForURI;
                String namespaceURI = f.getNamespaceURI();
                if (uri != null && !namespaceURI.equals(uri) || (prefixForURI = nsContext.getPrefixForURI(namespaceURI, (XmlElement)PsiTreeUtil.getContextOfType((PsiElement)element, XmlElement.class, (boolean)true))) == null && namespaceURI.length() > 0) continue;
                p = qn == null || qn.getPrefix() == null ? CompletionLists.makePrefix(prefixForURI) : "";
            } else {
                p = "";
            }
            lookups.add(FunctionLookup.newFunctionLookup(p + f.getLocalPart(), functionDecl));
        }
        return lookups;
    }

    public static Collection<Lookup> getVariableCompletions(XPathElement reference) {
        ContextProvider contextProvider = ContextProvider.getContextProvider(reference);
        VariableContext resolver = contextProvider.getVariableContext();
        if (resolver != null) {
            VarType[] variablesInScope = resolver.getVariablesInScope(reference);
            ArrayList<Lookup> lookups = new ArrayList<Lookup>(variablesInScope.length);
            for (Object o : variablesInScope) {
                if (o instanceof PsiNamedElement) {
                    XPathType t;
                    String type = o instanceof XPathVariable ? ((t = ((XPathVariable)o).getType()) != XPathType.UNKNOWN ? t.getName() : "") : "";
                    String name = ((PsiNamedElement)o).getName();
                    lookups.add(new VariableLookup("$" + name, type, ((PsiNamedElement)o).getIcon(0), (PsiElement)o));
                    continue;
                }
                lookups.add(new VariableLookup("$" + String.valueOf(o), PlatformIcons.VARIABLE_ICON));
            }
            return lookups;
        }
        return Collections.emptySet();
    }

    public static Collection<Lookup> getNodeTestCompletions(XPathNodeTest element) {
        if (!element.isNameTest()) {
            return Collections.emptyList();
        }
        PrefixedName prefixedName = element.getQName();
        assert (prefixedName != null);
        String canonicalText = prefixedName.toString();
        String suffix = canonicalText.substring(canonicalText.indexOf(INTELLIJ_IDEA_RULEZ));
        XPathAxisSpecifier axisSpecifier = element.getStep().getAxisSpecifier();
        ContextProvider contextProvider = ContextProvider.getContextProvider(element);
        XmlElement context = contextProvider.getContextElement();
        boolean insidePrefix = suffix.contains("IntellijIdeaRulezzz:");
        HashSet<Lookup> list = new HashSet<Lookup>();
        CompletionLists.addNameCompletions(contextProvider, element, list);
        String namespacePrefix = prefixedName.getPrefix();
        if (namespacePrefix == null || insidePrefix) {
            CompletionLists.addNamespaceCompletions(contextProvider.getNamespaceContext(), list, context);
        }
        XPathNodeTest.PrincipalType principalType = CompletionLists.addContextNames(element, contextProvider, prefixedName, list);
        if (namespacePrefix == null && !insidePrefix) {
            if (axisSpecifier == null || axisSpecifier.isDefaultAxis()) {
                boolean check;
                list.addAll(CompletionLists.getAxisCompletions());
                PsiElement sibling = element.getParent().getPrevSibling();
                while (sibling instanceof PsiWhiteSpace) {
                    sibling = sibling.getPrevSibling();
                }
                boolean bl = check = sibling != null;
                if (!check) {
                    XPathLocationPath lp = null;
                    while ((lp = (XPathLocationPath)PsiTreeUtil.getParentOfType((PsiElement)(lp == null ? element : lp), XPathLocationPath.class, (boolean)true)) != null && lp.getPrevSibling() == null) {
                    }
                    boolean bl2 = check = lp == null || (sibling = lp.getPrevSibling()) != null;
                }
                if (!(!check || sibling instanceof XPathToken && XPathTokenTypes.PATH_OPS.contains(((XPathToken)sibling).getTokenType()))) {
                    list.addAll(CompletionLists.getFunctionCompletions(element));
                    list.addAll(CompletionLists.getVariableCompletions(element));
                }
            }
            if (principalType == XPathNodeTest.PrincipalType.ELEMENT && prefixedName.getPrefix() == null) {
                list.addAll(CompletionLists.getNodeTypeCompletions(element));
            }
        }
        return list;
    }

    private static XPathNodeTest.PrincipalType addContextNames(XPathNodeTest element, ContextProvider contextProvider, PrefixedName prefixedName, Set<Lookup> list) {
        XPathNodeTest.PrincipalType principalType;
        block6: {
            Set<QName> attributeNames;
            XmlElement context;
            NamespaceContext namespaceContext;
            block5: {
                namespaceContext = contextProvider.getNamespaceContext();
                context = contextProvider.getContextElement();
                principalType = element.getPrincipalType();
                if (principalType != XPathNodeTest.PrincipalType.ELEMENT) break block5;
                Set<QName> elementNames = contextProvider.getElements(false);
                if (elementNames == null) break block6;
                for (QName pair : elementNames) {
                    if ("*".equals(pair.getLocalPart()) || !CompletionLists.namespaceMatches(prefixedName, pair.getNamespaceURI(), namespaceContext, context, true)) continue;
                    if (prefixedName.getPrefix() == null && namespaceContext != null) {
                        String p = namespaceContext.getPrefixForURI(pair.getNamespaceURI(), context);
                        list.add(new NodeLookup(CompletionLists.makePrefix(p) + pair.getLocalPart(), XPathNodeTest.PrincipalType.ELEMENT));
                        continue;
                    }
                    list.add(new NodeLookup(pair.getLocalPart(), XPathNodeTest.PrincipalType.ELEMENT));
                }
                break block6;
            }
            if (principalType == XPathNodeTest.PrincipalType.ATTRIBUTE && (attributeNames = contextProvider.getAttributes(false)) != null) {
                for (QName pair : attributeNames) {
                    if ("*".equals(pair.getLocalPart()) || !CompletionLists.namespaceMatches(prefixedName, pair.getNamespaceURI(), namespaceContext, context, false)) continue;
                    if (prefixedName.getPrefix() == null && namespaceContext != null) {
                        String p = namespaceContext.getPrefixForURI(pair.getNamespaceURI(), context);
                        list.add(new NodeLookup(CompletionLists.makePrefix(p) + pair.getLocalPart(), XPathNodeTest.PrincipalType.ATTRIBUTE));
                        continue;
                    }
                    list.add(new NodeLookup(pair.getLocalPart(), XPathNodeTest.PrincipalType.ATTRIBUTE));
                }
            }
        }
        return principalType;
    }

    private static String makePrefix(String p) {
        return p != null && p.length() > 0 ? p + ":" : "";
    }

    private static void addNamespaceCompletions(NamespaceContext namespaceContext, Set<Lookup> list, XmlElement context) {
        if (namespaceContext != null) {
            Collection<String> knownPrefixes = namespaceContext.getKnownPrefixes(context);
            for (String prefix : knownPrefixes) {
                if (prefix == null || prefix.length() <= 0) continue;
                list.add(new NamespaceLookup(prefix));
            }
        }
    }

    private static void addNameCompletions(ContextProvider contextProvider, XPathNodeTest element, final Set<Lookup> list) {
        final PrefixedName prefixedName = element.getQName();
        final XPathNodeTest.PrincipalType principalType = element.getPrincipalType();
        HashSet<XPathFile> files = new HashSet<XPathFile>();
        XPathFile file = (XPathFile)element.getContainingFile();
        files.add(file);
        ContainerUtil.addAll(files, (Object[])contextProvider.getRelatedFiles(file));
        for (PsiFile psiFile : files) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement e) {
                    String localName;
                    PrefixedName _prefixedName;
                    XPathNodeTest nodeTest;
                    XPathNodeTest.PrincipalType _principalType;
                    if (e instanceof XPathNodeTest && (_principalType = (nodeTest = (XPathNodeTest)e).getPrincipalType()) == principalType && (_prefixedName = nodeTest.getQName()) != null && prefixedName != null && !"*".equals(localName = _prefixedName.getLocalName()) && !localName.contains(CompletionLists.INTELLIJ_IDEA_RULEZ)) {
                        if (Comparing.equal((String)_prefixedName.getPrefix(), (String)prefixedName.getPrefix())) {
                            list.add(new NodeLookup(localName, _principalType));
                        } else if (prefixedName.getPrefix() == null) {
                            list.add(new NodeLookup(_prefixedName.toString(), _principalType));
                        }
                    }
                    super.visitElement(e);
                }
            });
        }
    }

    private static boolean namespaceMatches(PrefixedName prefixedName, String uri, NamespaceContext namespaceContext, XmlElement context, boolean allowDefault) {
        String namespaceURI;
        if (namespaceContext == null) {
            return true;
        }
        if (prefixedName.getPrefix() != null) {
            if (uri == null || uri.length() == 0) {
                return false;
            }
            namespaceURI = namespaceContext.getNamespaceURI(prefixedName.getPrefix(), context);
        } else {
            if (!allowDefault) {
                return uri == null || uri.length() == 0;
            }
            namespaceURI = namespaceContext.getDefaultNamespace(context);
            if (namespaceURI == null) {
                return uri == null || uri.length() == 0;
            }
        }
        return uri.equals(namespaceURI);
    }

    public static Collection<Lookup> getNodeTypeCompletions(XPathElement context) {
        Set<String> funcs = context.getXPathVersion() == XPathVersion.V1 ? NODE_TYPE_FUNCS : NODE_TYPE_FUNCS_V2;
        return ContainerUtil.map(funcs, FUNCTION_MAPPING);
    }

    public static Collection<Lookup> getAxisCompletions() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>(AXIS_NAMES.size());
        for (String s : AXIS_NAMES) {
            lookups.add(new AxisLookup(s));
        }
        return lookups;
    }

    public static Class[] getAllInterfaces(Class<?> clazz) {
        HashSet set = new HashSet();
        do {
            ContainerUtil.addAll(set, (Object[])clazz.getInterfaces());
        } while ((clazz = clazz.getSuperclass()) != null);
        return set.toArray(new Class[set.size()]);
    }
}

