/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomCustomClasspathComponent;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.lang.ant.dom.CustomAntElementsRegistry;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import org.apache.tools.ant.Task;

public abstract class AntDomTypeDef
extends AntDomCustomClasspathComponent {
    @Attribute(value="classname")
    public abstract GenericAttributeValue<String> getClassName();

    @Attribute(value="file")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getFile();

    @Attribute(value="resource")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getResource();

    @Attribute(value="format")
    public abstract GenericAttributeValue<String> getFormat();

    @Attribute(value="adapter")
    public abstract GenericAttributeValue<String> getAdapter();

    @Attribute(value="adaptto")
    public abstract GenericAttributeValue<String> getAdaptto();

    public final boolean hasTypeLoadingErrors() {
        return CustomAntElementsRegistry.getInstance(this.getAntProject()).hasTypeLoadingErrors(this);
    }

    public final List<String> getErrorDescriptions() {
        return CustomAntElementsRegistry.getInstance(this.getAntProject()).getTypeLoadingErrors(this);
    }

    public boolean isTask(Class clazz) {
        if ("taskdef".equals(this.getXmlTag().getName())) {
            return true;
        }
        String adaptto = this.getAdaptto().getStringValue();
        if (adaptto != null && AntDomTypeDef.isAssignableFrom(adaptto, clazz)) {
            return AntDomTypeDef.isAssignableFrom(Task.class.getName(), clazz);
        }
        String adapter = this.getAdapter().getStringValue();
        if (adapter != null) {
            try {
                Class<?> adapterClass = clazz.getClassLoader().loadClass(adapter);
                return AntDomTypeDef.isAssignableFrom(Task.class.getName(), adapterClass);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoClassDefFoundError ignored) {
            }
            catch (UnsupportedClassVersionError ignored) {
                // empty catch block
            }
        }
        return AntDomTypeDef.isAssignableFrom(Task.class.getName(), clazz);
    }

    private static boolean isAssignableFrom(String baseClassName, Class clazz) {
        try {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                Class<?> baseClass = loader.loadClass(baseClassName);
                return baseClass.isAssignableFrom(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

