/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomClasspathComponent;
import com.intellij.lang.ant.dom.AntDomPropertyValueConverter;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.lang.ant.dom.AntPathValidatingConverter;
import com.intellij.lang.ant.dom.CustomAntElementsRegistry;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTarget;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AntDomProperty
extends AntDomClasspathComponent
implements PropertiesProvider {
    private volatile Map<String, String> myCachedProperties;
    private volatile ClassLoader myCachedLoader;

    @Attribute(value="value")
    @Convert(value=AntDomPropertyValueConverter.class)
    public abstract GenericAttributeValue<Object> getValue();

    @Attribute(value="location")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getLocation();

    @Attribute(value="resource")
    public abstract GenericAttributeValue<String> getResource();

    @Attribute(value="file")
    @Convert(value=AntPathValidatingConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getFile();

    @Attribute(value="url")
    public abstract GenericAttributeValue<String> getUrl();

    @Attribute(value="environment")
    public abstract GenericAttributeValue<String> getEnvironment();

    @Attribute(value="prefix")
    public abstract GenericAttributeValue<String> getPrefix();

    @Attribute(value="relative")
    public abstract GenericAttributeValue<String> getRelative();

    @Attribute(value="basedir")
    public abstract GenericAttributeValue<String> getbasedir();

    @Override
    @NotNull
    public final Iterator<String> getNamesIterator() {
        final String prefix = this.getPropertyPrefixValue();
        final Iterator<String> delegate = this.buildProperties().keySet().iterator();
        if (prefix == null) {
            Iterator<String> iterator = delegate;
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomProperty", "getNamesIterator"));
            }
            return iterator;
        }
        Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public String next() {
                return prefix + (String)delegate.next();
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomProperty", "getNamesIterator"));
        }
        return iterator;
    }

    @Override
    public PsiElement getNavigationElement(String propertyName) {
        PsiElement psi;
        DomTarget domTarget = DomTarget.getTarget((DomElement)this);
        if (domTarget == null) {
            GenericAttributeValue<String> resource;
            GenericAttributeValue<String> environment = this.getEnvironment();
            if (environment.getRawText() != null) {
                domTarget = DomTarget.getTarget((DomElement)this, environment);
            }
            if (domTarget == null && (resource = this.getResource()).getRawText() != null) {
                domTarget = DomTarget.getTarget((DomElement)this, resource);
            }
        }
        if (domTarget != null && (psi = PomService.convertToPsi((PsiTarget)domTarget)) != null) {
            return psi;
        }
        PsiFileSystemItem psiFile = (PsiFileSystemItem)this.getFile().getValue();
        if (psiFile != null) {
            PropertiesFile pf;
            String prefix = this.getPropertyPrefixValue();
            String _propertyName = propertyName;
            if (prefix != null) {
                if (!propertyName.startsWith(prefix)) {
                    return null;
                }
                _propertyName = propertyName.substring(prefix.length());
            }
            if ((pf = AntDomProperty.toPropertiesFile(psiFile)) != null) {
                IProperty property = pf.findPropertyByKey(_propertyName);
                return property != null ? property.getPsiElement() : null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final String getPropertyValue(String propertyName) {
        String prefix = this.getPropertyPrefixValue();
        if (prefix != null) {
            if (!propertyName.startsWith(prefix)) {
                return null;
            }
            propertyName = propertyName.substring(prefix.length());
        }
        return this.buildProperties().get(propertyName);
    }

    private Map<String, String> buildProperties() {
        Object result = this.myCachedProperties;
        if (result != null) {
            return result;
        }
        result = Collections.emptyMap();
        String propertyName = this.getName().getRawText();
        if (propertyName != null) {
            String propertyValue = this.getValue().getRawText();
            if (propertyValue != null) {
                result = Collections.singletonMap(propertyName, propertyValue);
            } else {
                String locValue = this.getLocation().getStringValue();
                if (locValue != null) {
                    String baseDir;
                    File file = new File(locValue);
                    if (!file.isAbsolute() && (baseDir = this.getContextAntProject().getProjectBasedirPath()) != null) {
                        locValue = PathUtil.getCanonicalPath((String)new File(baseDir, locValue).getPath());
                    }
                    result = Collections.singletonMap(propertyName, FileUtil.toSystemDependentName((String)locValue));
                } else {
                    String tagText = this.getXmlTag().getText();
                    result = Collections.singletonMap(propertyName, tagText);
                }
            }
        } else {
            PsiFileSystemItem psiFile = (PsiFileSystemItem)this.getFile().getValue();
            if (psiFile != null) {
                PropertiesFile file = AntDomProperty.toPropertiesFile(psiFile);
                if (file != null) {
                    result = new HashMap();
                    for (IProperty property : file.getProperties()) {
                        result.put(property.getUnescapedKey(), property.getUnescapedValue());
                    }
                }
            } else if (this.getEnvironment().getRawText() != null) {
                String prefix = this.getEnvironment().getRawText();
                if (!prefix.endsWith(".")) {
                    prefix = prefix + ".";
                }
                result = new HashMap();
                for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                    result.put(prefix + entry.getKey(), entry.getValue());
                }
            } else {
                InputStream stream;
                ClassLoader loader;
                String resource = this.getResource().getStringValue();
                if (resource != null && (loader = this.getClassLoader()) != null && (stream = loader.getResourceAsStream(resource)) != null) {
                    try {
                        PropertiesFile propFile = (PropertiesFile)CustomAntElementsRegistry.loadContentAsFile(this.getXmlTag().getProject(), stream, StdFileTypes.PROPERTIES);
                        result = new HashMap();
                        for (IProperty property : propFile.getProperties()) {
                            result.put(property.getUnescapedKey(), property.getUnescapedValue());
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        this.myCachedProperties = result;
        return this.myCachedProperties;
    }

    @Nullable
    public String getPropertyPrefixValue() {
        boolean prefixIsApplicable;
        GenericAttributeValue<String> prefixValue = this.getPrefix();
        if (prefixValue == null) {
            return null;
        }
        boolean bl = prefixIsApplicable = this.getName().getRawText() == null && (this.getUrl().getRawText() != null || this.getFile().getRawText() != null || this.getResource().getRawText() != null);
        if (!prefixIsApplicable) {
            return null;
        }
        String prefix = prefixValue.getRawText();
        if (prefix != null && !prefix.endsWith(".")) {
            return prefix + ".";
        }
        return prefix;
    }

    @Nullable
    private ClassLoader getClassLoader() {
        ClassLoader loader = this.myCachedLoader;
        if (loader == null) {
            this.myCachedLoader = loader = CustomAntElementsRegistry.createClassLoader(CustomAntElementsRegistry.collectUrls(this), this.getContextAntProject());
        }
        return loader;
    }

    @Nullable
    public PropertiesFile getPropertiesFile() {
        return AntDomProperty.toPropertiesFile((PsiFileSystemItem)this.getFile().getValue());
    }

    @Nullable
    private static PropertiesFile toPropertiesFile(@Nullable PsiFileSystemItem item) {
        if (item instanceof PropertiesFile) {
            return (PropertiesFile)item;
        }
        return item instanceof PsiFile ? PropertiesImplUtil.getPropertiesFile((PsiFile)((PsiFile)item)) : null;
    }
}

