/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.ModifiableCellAppearanceEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class AllJarsUnderDirEntry
implements AntClasspathEntry {
    @NonNls
    private static final String JAR_SUFFIX = ".jar";
    private static final Function<VirtualFile, AntClasspathEntry> CREATE_FROM_VIRTUAL_FILE = new Function<VirtualFile, AntClasspathEntry>(){

        public AntClasspathEntry fun(VirtualFile file) {
            return AllJarsUnderDirEntry.fromVirtualFile(file);
        }
    };
    @NonNls
    static final String DIR = "dir";
    private final File myDir;

    public AllJarsUnderDirEntry(File dir) {
        this.myDir = dir;
    }

    public AllJarsUnderDirEntry(String osPath) {
        this(new File(osPath));
    }

    @Override
    public void writeExternal(Element dataElement) {
        String url = VirtualFileManager.constructUrl((String)"file", (String)this.myDir.getAbsolutePath().replace(File.separatorChar, '/'));
        dataElement.setAttribute(DIR, url);
    }

    @Override
    public void addFilesTo(List<File> files) {
        Object[] children = this.myDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathName) {
                return pathName.getName().endsWith(AllJarsUnderDirEntry.JAR_SUFFIX) && pathName.isFile();
            }
        });
        if (children != null) {
            ContainerUtil.addAll(files, (Object[])children);
        }
    }

    @Override
    public CellAppearanceEx getAppearance() {
        CellAppearanceEx appearance = FileAppearanceService.getInstance().forIoFile(this.myDir);
        if (appearance instanceof ModifiableCellAppearanceEx) {
            ((ModifiableCellAppearanceEx)appearance).setIcon(AllIcons.Nodes.JarDirectory);
        }
        return appearance;
    }

    private static AntClasspathEntry fromVirtualFile(VirtualFile file) {
        return new AllJarsUnderDirEntry(file.getPath());
    }

    public static class AddEntriesFactory
    extends AntClasspathEntry.AddEntriesFactory {
        public AddEntriesFactory(JComponent parentComponent) {
            super(parentComponent, FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), (Function<VirtualFile, AntClasspathEntry>)CREATE_FROM_VIRTUAL_FILE);
        }
    }
}

