/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ExceptionUtil;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ReflectedProject {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.ReflectedProject");
    @NonNls
    private static final String INIT_METHOD_NAME = "init";
    @NonNls
    private static final String GET_TASK_DEFINITIONS_METHOD_NAME = "getTaskDefinitions";
    @NonNls
    private static final String GET_DATA_TYPE_DEFINITIONS_METHOD_NAME = "getDataTypeDefinitions";
    @NonNls
    private static final String GET_PROPERTIES_METHOD_NAME = "getProperties";
    private static final List<SoftReference<Pair<ReflectedProject, ClassLoader>>> ourProjects = new ArrayList<SoftReference<Pair<ReflectedProject, ClassLoader>>>();
    private static final ReentrantLock ourProjectsLock = new ReentrantLock();
    private final Object myProject;
    private Hashtable myTaskDefinitions;
    private Hashtable myDataTypeDefinitions;
    private Hashtable myProperties;
    private Class myTargetClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectedProject getProject(ClassLoader classLoader) {
        ourProjectsLock.lock();
        try {
            Iterator<SoftReference<Pair<ReflectedProject, ClassLoader>>> iterator = ourProjects.iterator();
            while (iterator.hasNext()) {
                SoftReference<Pair<ReflectedProject, ClassLoader>> ref = iterator.next();
                Pair<ReflectedProject, ClassLoader> pair = ref.get();
                if (pair == null) {
                    iterator.remove();
                    continue;
                }
                if (pair.second != classLoader) continue;
                ReflectedProject reflectedProject = (ReflectedProject)pair.first;
                return reflectedProject;
            }
        }
        finally {
            ourProjectsLock.unlock();
        }
        ReflectedProject reflectedProj = new ReflectedProject(classLoader);
        ourProjectsLock.lock();
        try {
            ourProjects.add(new SoftReference<Pair>(Pair.create((Object)reflectedProj, (Object)classLoader)));
        }
        finally {
            ourProjectsLock.unlock();
        }
        return reflectedProj;
    }

    ReflectedProject(ClassLoader classLoader) {
        Object project = null;
        try {
            Class<?> projectClass = classLoader.loadClass("org.apache.tools.ant.Project");
            if (projectClass != null) {
                project = projectClass.newInstance();
                Method method = projectClass.getMethod(INIT_METHOD_NAME, new Class[0]);
                method.invoke(project, new Object[0]);
                method = ReflectedProject.getMethod(projectClass, GET_TASK_DEFINITIONS_METHOD_NAME);
                this.myTaskDefinitions = (Hashtable)method.invoke(project, new Object[0]);
                method = ReflectedProject.getMethod(projectClass, GET_DATA_TYPE_DEFINITIONS_METHOD_NAME);
                this.myDataTypeDefinitions = (Hashtable)method.invoke(project, new Object[0]);
                method = ReflectedProject.getMethod(projectClass, GET_PROPERTIES_METHOD_NAME);
                this.myProperties = (Hashtable)method.invoke(project, new Object[0]);
                this.myTargetClass = classLoader.loadClass("org.apache.tools.ant.Target");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable cause = ExceptionUtil.getRootCause((Throwable)e);
            if (cause instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)cause;
            }
            LOG.info(e);
            project = null;
        }
        this.myProject = project;
    }

    private static Method getMethod(Class introspectionHelperClass, String name) throws NoSuchMethodException {
        Method method = introspectionHelperClass.getMethod(name, new Class[0]);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    @Nullable
    public Hashtable<String, Class> getTaskDefinitions() {
        return this.myTaskDefinitions;
    }

    @Nullable
    public Hashtable<String, Class> getDataTypeDefinitions() {
        return this.myDataTypeDefinitions;
    }

    public Hashtable getProperties() {
        return this.myProperties;
    }

    public Class getTargetClass() {
        return this.myTargetClass;
    }

    @Nullable
    public Object getProject() {
        return this.myProject;
    }
}

