/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectionAcceptor;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.process.internal.DefaultWorkerProcess;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ApplicationClassesInIsolatedClassLoaderWorkerFactory;
import org.gradle.process.internal.child.ApplicationClassesInSystemClassLoaderWorkerFactory;
import org.gradle.process.internal.child.EncodedStream;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessFactory
implements Factory<WorkerProcessBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessFactory.class);
    private final LogLevel workerLogLevel;
    private final MessagingServer server;
    private final ClassPathRegistry classPathRegistry;
    private final FileResolver resolver;
    private final IdGenerator<?> idGenerator;

    public DefaultWorkerProcessFactory(LogLevel workerLogLevel, MessagingServer server, ClassPathRegistry classPathRegistry, FileResolver resolver, IdGenerator<?> idGenerator) {
        this.workerLogLevel = workerLogLevel;
        this.server = server;
        this.classPathRegistry = classPathRegistry;
        this.resolver = resolver;
        this.idGenerator = idGenerator;
    }

    public WorkerProcessBuilder create() {
        return new DefaultWorkerProcessBuilder();
    }

    private class DefaultWorkerProcessBuilder
    extends WorkerProcessBuilder {
        public DefaultWorkerProcessBuilder() {
            super(DefaultWorkerProcessFactory.this.resolver);
            this.setLogLevel(DefaultWorkerProcessFactory.this.workerLogLevel);
        }

        public WorkerProcess build() {
            if (this.getWorker() == null) {
                throw new IllegalStateException("No worker action specified for this worker process.");
            }
            final DefaultWorkerProcess workerProcess = new DefaultWorkerProcess(120, TimeUnit.SECONDS);
            ConnectionAcceptor acceptor = DefaultWorkerProcessFactory.this.server.accept((Action)new Action<ObjectConnection>(){

                public void execute(ObjectConnection connection) {
                    workerProcess.onConnect(connection);
                }
            });
            workerProcess.startAccepting(acceptor);
            Address localAddress = acceptor.getAddress();
            List implementationClassPath = ClasspathUtil.getClasspath((ClassLoader)this.getWorker().getClass().getClassLoader());
            Object id = DefaultWorkerProcessFactory.this.idGenerator.generateId();
            String displayName = this.getBaseName() + " " + id;
            WorkerFactory workerFactory = this.isLoadApplicationInSystemClassLoader() ? new ApplicationClassesInSystemClassLoaderWorkerFactory(id, displayName, this, implementationClassPath, localAddress, DefaultWorkerProcessFactory.this.classPathRegistry) : new ApplicationClassesInIsolatedClassLoaderWorkerFactory(id, displayName, this, implementationClassPath, localAddress, DefaultWorkerProcessFactory.this.classPathRegistry);
            LOGGER.debug("Creating {}", (Object)displayName);
            LOGGER.debug("Using application classpath {}", this.getApplicationClasspath());
            LOGGER.debug("Using implementation classpath {}", (Object)implementationClassPath);
            JavaExecHandleBuilder javaCommand = this.getJavaCommand();
            this.attachStdInContent(workerFactory, javaCommand);
            workerFactory.prepareJavaCommand(javaCommand);
            javaCommand.setDisplayName(displayName);
            javaCommand.args("'" + displayName + "'");
            ExecHandle execHandle = javaCommand.build();
            workerProcess.setExecHandle(execHandle);
            return workerProcess;
        }

        private void attachStdInContent(WorkerFactory workerFactory, JavaExecHandleBuilder javaCommand) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            EncodedStream.EncodedOutput encoded = new EncodedStream.EncodedOutput(bytes);
            GUtil.serialize(workerFactory.create(), encoded);
            ByteArrayInputStream stdinContent = new ByteArrayInputStream(bytes.toByteArray());
            javaCommand.setStandardInput(stdinContent);
        }
    }
}

