/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationAwareException
extends GradleException
implements FailureResolutionAware {
    private final ScriptSource source;
    private final Integer lineNumber;

    public LocationAwareException(Throwable cause, ScriptSource source, Integer lineNumber) {
        this.source = source;
        this.lineNumber = lineNumber;
        this.initCause(cause);
    }

    public ScriptSource getScriptSource() {
        return this.source;
    }

    public String getLocation() {
        if (this.source == null) {
            return null;
        }
        String sourceMsg = StringUtils.capitalize((String)this.source.getDisplayName());
        if (this.lineNumber == null) {
            return sourceMsg;
        }
        return String.format("%s line: %d", sourceMsg, this.lineNumber);
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        String location = this.getLocation();
        String message = this.getCause().getMessage();
        if (location == null && message == null) {
            return null;
        }
        if (location == null) {
            return message;
        }
        if (message == null) {
            return location;
        }
        return String.format("%s%n%s", location, message);
    }

    @Override
    public void appendResolution(StyledTextOutput output, BuildClientMetaData clientMetaData) {
        if (this.getCause() instanceof FailureResolutionAware) {
            FailureResolutionAware resolutionAware = (FailureResolutionAware)((Object)this.getCause());
            resolutionAware.appendResolution(output, clientMetaData);
        }
    }

    public List<Throwable> getReportableCauses() {
        final ArrayList<Throwable> causes = new ArrayList<Throwable>();
        this.visitCauses(this.getCause(), (TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){

            @Override
            public void node(Throwable node) {
                causes.add(node);
            }
        });
        return causes;
    }

    public void visitReportableCauses(TreeVisitor<? super Throwable> visitor) {
        visitor.node((Throwable)((Object)this));
        this.visitCauses(this.getCause(), visitor);
    }

    private void visitCauses(Throwable t, TreeVisitor<? super Throwable> visitor) {
        if (t instanceof MultiCauseException) {
            MultiCauseException multiCauseException = (MultiCauseException)((Object)t);
            List<? extends Throwable> causes = multiCauseException.getCauses();
            if (!causes.isEmpty()) {
                visitor.startChildren();
                for (Throwable throwable : causes) {
                    visitor.node(throwable);
                    if (throwable.getClass().getAnnotation(Contextual.class) == null) continue;
                    this.visitCauses(throwable, visitor);
                }
                visitor.endChildren();
            }
            return;
        }
        if (t.getCause() != null) {
            visitor.startChildren();
            Throwable next = this.findNearestContextualCause(t);
            if (next != null) {
                visitor.node(next);
                this.visitCauses(next, visitor);
            } else {
                visitor.node(t.getCause());
            }
            visitor.endChildren();
        }
    }

    private Throwable findNearestContextualCause(Throwable t) {
        if (t.getCause() == null) {
            return null;
        }
        Throwable cause = t.getCause();
        if (cause.getClass().getAnnotation(Contextual.class) != null) {
            return cause;
        }
        return this.findNearestContextualCause(cause);
    }
}

