/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.plugin.use.internal.PluginDependenciesService;
import org.gradle.plugin.use.internal.PluginUseScriptBlockTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsAndBuildscriptTransformer
implements StatementTransformer {
    private static final String PLUGINS = "plugins";
    private final String classpathBlockName;
    private final String pluginsBlockMessage;
    private final PluginUseScriptBlockTransformer pluginBlockTransformer;
    private boolean seenNonClasspathStatement;
    private boolean seenPluginsBlock;
    private final List<String> scriptBlockNames;
    private final Spec<Statement> statementSpec = new Spec<Statement>(){

        public boolean isSatisfiedBy(Statement statement) {
            return AstUtils.detectScriptBlock((Statement)statement, (Collection)PluginsAndBuildscriptTransformer.this.scriptBlockNames) != null;
        }
    };

    public PluginsAndBuildscriptTransformer(String classpathBlockName, String pluginsBlockMessage, DocumentationRegistry documentationRegistry) {
        this.classpathBlockName = classpathBlockName;
        this.scriptBlockNames = Arrays.asList(classpathBlockName, PLUGINS);
        this.pluginsBlockMessage = pluginsBlockMessage;
        this.pluginBlockTransformer = new PluginUseScriptBlockTransformer("__scriptServices", PluginDependenciesService.class, documentationRegistry);
    }

    public Statement transform(SourceUnit sourceUnit, Statement statement) {
        ScriptBlock scriptBlock = AstUtils.detectScriptBlock((Statement)statement, this.scriptBlockNames);
        if (scriptBlock == null) {
            this.seenNonClasspathStatement = true;
            return null;
        }
        if (scriptBlock.getName().equals(PLUGINS)) {
            String failMessage = null;
            Statement returnStatement = statement;
            if (this.pluginsBlockMessage != null) {
                failMessage = this.pluginBlockTransformer.formatErrorMessage(this.pluginsBlockMessage);
            } else {
                this.seenPluginsBlock = true;
                if (this.seenNonClasspathStatement) {
                    failMessage = String.format(this.pluginBlockTransformer.formatErrorMessage("only %s {} and other %s {} script blocks are allowed before %s {} blocks, no other statements are allowed"), this.classpathBlockName, PLUGINS, PLUGINS);
                } else {
                    returnStatement = this.pluginBlockTransformer.transform(sourceUnit, scriptBlock);
                }
            }
            if (failMessage != null) {
                sourceUnit.getErrorCollector().addError(new SyntaxException(failMessage, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
            }
            return returnStatement;
        }
        if (this.seenPluginsBlock) {
            String message = String.format(this.pluginBlockTransformer.formatErrorMessage("all %s {} blocks must appear before any %s {} blocks in the script"), this.classpathBlockName, PLUGINS);
            sourceUnit.getErrorCollector().addError(new SyntaxException(message, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
        }
        return statement;
    }

    public Spec<Statement> getSpec() {
        return this.statementSpec;
    }
}

