/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheCoordinator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultCacheAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factory;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private final File dir;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final String displayName;
    private CacheCoordinator cacheAccess;

    public DefaultPersistentDirectoryStore(File dir, String displayName, LockOptions lockOptions, FileLockManager fileLockManager) {
        this.dir = dir;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
        this.displayName = displayName != null ? String.format("%s (%s)", displayName, dir) : String.format("cache directory %s (%s)", dir.getName(), dir);
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        GFileUtils.mkdirs(this.dir);
        this.cacheAccess = this.createCacheAccess();
        try {
            this.cacheAccess.open(this.lockOptions);
        }
        catch (Throwable e) {
            throw new CacheOpenException(String.format("Could not open %s.", this), e);
        }
        return this;
    }

    private CacheCoordinator createCacheAccess() {
        return new DefaultCacheAccess(this.displayName, this.getLockTarget(), this.dir, this.lockManager, this.getInitAction());
    }

    protected File getLockTarget() {
        return this.dir;
    }

    protected CacheInitializationAction getInitAction() {
        return new CacheInitializationAction(){

            public boolean requiresInitialization(FileLock fileLock) {
                return false;
            }

            public void initialize(FileLock fileLock) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
        return this.cacheAccess.newCache(parameters);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
        return this.cacheAccess.newCache(new PersistentIndexedCacheParameters<K, V>(name, keyType, valueSerializer));
    }

    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        return this.cacheAccess.useCache(operationDisplayName, action);
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.cacheAccess.useCache(operationDisplayName, action);
    }

    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        return this.cacheAccess.longRunningOperation(operationDisplayName, action);
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.cacheAccess.longRunningOperation(operationDisplayName, action);
    }
}

