/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Factory;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptHandler
implements ScriptHandler {
    private final ScriptSource scriptSource;
    private final RepositoryHandler repositoryHandler;
    private final DependencyHandler dependencyHandler;
    private final ConfigurationContainer configContainer;
    private final Factory<ClassLoader> classLoaderFactory;
    private final Configuration classpathConfiguration;

    public DefaultScriptHandler(ScriptSource scriptSource, RepositoryHandler repositoryHandler, DependencyHandler dependencyHandler, ConfigurationContainer configContainer, Factory<ClassLoader> classLoaderFactory) {
        this.repositoryHandler = repositoryHandler;
        this.dependencyHandler = dependencyHandler;
        this.scriptSource = scriptSource;
        this.configContainer = configContainer;
        this.classLoaderFactory = classLoaderFactory;
        this.classpathConfiguration = (Configuration)configContainer.create("classpath");
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.dependencyHandler);
    }

    protected Configuration getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    @Override
    public DependencyHandler getDependencies() {
        return this.dependencyHandler;
    }

    @Override
    public RepositoryHandler getRepositories() {
        return this.repositoryHandler;
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.repositoryHandler);
    }

    @Override
    public ConfigurationContainer getConfigurations() {
        return this.configContainer;
    }

    @Override
    public File getSourceFile() {
        return this.scriptSource.getResource().getFile();
    }

    @Override
    public URI getSourceURI() {
        return this.scriptSource.getResource().getURI();
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderFactory.create();
    }
}

