/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.initialization.ClassLoaderCache;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderScope
implements ClassLoaderScope {
    public static final String STRICT_MODE_PROPERTY = "org.gradle.classloaderscope.strict";
    private final ClassLoaderScope parent;
    private final ClassLoaderCache classLoaderCache;
    private boolean locked;
    private List<ClassPath> export = new LinkedList<ClassPath>();
    private List<ClassPath> local = new LinkedList<ClassPath>();
    private MultiParentClassLoader exportingClassLoader;
    private MultiParentClassLoader localClassLoader;
    private ClassLoader effectiveLocalClassLoader;
    private ClassLoader effectiveExportClassLoader;

    public DefaultClassLoaderScope(ClassLoaderScope parent, ClassLoaderCache classLoaderCache) {
        this.parent = parent;
        this.classLoaderCache = classLoaderCache;
    }

    private ClassLoader buildLockedLoader(List<ClassPath> classPaths) {
        if (classPaths.isEmpty()) {
            return this.parent.getExportClassLoader();
        }
        if (classPaths.size() == 1) {
            return this.loader(classPaths.get(0));
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(classPaths.size());
        for (ClassPath classPath : classPaths) {
            loaders.add(this.loader(classPath));
        }
        return new CachingClassLoader((ClassLoader)new MultiParentClassLoader(loaders));
    }

    private ClassLoader buildLockedLoader(ClassLoader additional, List<ClassPath> classPaths) {
        if (classPaths.isEmpty()) {
            return additional;
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(classPaths.size() + 1);
        loaders.add(additional);
        for (ClassPath classPath : classPaths) {
            loaders.add(this.loader(classPath));
        }
        return new CachingClassLoader((ClassLoader)new MultiParentClassLoader(loaders));
    }

    private MultiParentClassLoader buildOpenLoader(ClassLoader additional, List<ClassPath> classPaths) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(classPaths.size() + 1);
        loaders.add(additional);
        for (ClassPath classPath : classPaths) {
            loaders.add(this.loader(classPath));
        }
        return new MultiParentClassLoader(loaders);
    }

    private void buildEffectiveLoaders() {
        if (this.effectiveLocalClassLoader == null) {
            if (this.locked) {
                if (this.local.isEmpty() && this.export.isEmpty()) {
                    this.effectiveLocalClassLoader = this.parent.getExportClassLoader();
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (this.export.isEmpty()) {
                    this.effectiveLocalClassLoader = this.buildLockedLoader(this.local);
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (this.local.isEmpty()) {
                    this.effectiveExportClassLoader = this.effectiveLocalClassLoader = this.buildLockedLoader(this.export);
                } else {
                    this.effectiveExportClassLoader = this.buildLockedLoader(this.export);
                    this.effectiveLocalClassLoader = this.buildLockedLoader(this.effectiveExportClassLoader, this.local);
                }
            } else {
                if (Boolean.getBoolean(STRICT_MODE_PROPERTY)) {
                    throw new IllegalStateException("Attempt to define scope class loader before scope is locked");
                }
                this.exportingClassLoader = this.buildOpenLoader(this.parent.getExportClassLoader(), this.export);
                this.effectiveExportClassLoader = new CachingClassLoader((ClassLoader)this.exportingClassLoader);
                this.localClassLoader = this.buildOpenLoader(this.effectiveExportClassLoader, this.local);
                this.effectiveLocalClassLoader = new CachingClassLoader((ClassLoader)this.localClassLoader);
            }
            this.export = null;
            this.local = null;
        }
    }

    @Override
    public ClassLoader getExportClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveExportClassLoader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveLocalClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this.parent;
    }

    private ClassLoader loader(ClassPath classPath) {
        return this.classLoaderCache.get(this.parent.getExportClassLoader(), classPath, null);
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.localClassLoader != null) {
            this.localClassLoader.addParent(this.loader(classPath));
        } else {
            this.local.add(classPath);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent(this.loader(classPath));
        } else {
            this.export.add(classPath);
        }
        return this;
    }

    private void assertNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked");
        }
    }

    @Override
    public ClassLoaderScope createChild() {
        return new DefaultClassLoaderScope(this, this.classLoaderCache);
    }

    @Override
    public ClassLoaderScope lock() {
        this.locked = true;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }
}

