/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.internal.resources.URIBuilder;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceException;

public class GzipArchiver
implements ReadableResource {
    private ReadableResource resource;
    private URI uri;

    public GzipArchiver(ReadableResource resource) {
        assert (resource != null);
        this.resource = resource;
        this.uri = new URIBuilder(resource.getURI()).schemePrefix("gzip:").build();
    }

    public static ArchiveOutputStreamFactory getCompressor() {
        return new ArchiveOutputStreamFactory(){

            public OutputStream createArchiveOutputStream(File destination) {
                try {
                    FileOutputStream outStr = new FileOutputStream(destination);
                    return new GZIPOutputStream(outStr);
                }
                catch (Exception e) {
                    String message = String.format("Unable to create gzip output stream for file %s.", destination);
                    throw new RuntimeException(message, e);
                }
            }
        };
    }

    public InputStream read() {
        InputStream is = this.resource.read();
        try {
            return new GZIPInputStream(is);
        }
        catch (Exception e) {
            String message = String.format("Unable to create gzip input stream for resource %s.", this.resource.getDisplayName());
            throw new ResourceException(message, e);
        }
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getBaseName() {
        return this.resource.getBaseName();
    }
}

