/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final List<Object> source = new ArrayList<Object>();
    private final String name;
    private final String displayName;
    private final FileResolver fileResolver;
    private final PatternSet patterns = new PatternSet();
    private final PatternSet filter = new PatternSet();

    public DefaultSourceDirectorySet(String name, String displayName, FileResolver fileResolver) {
        this.name = name;
        this.displayName = displayName;
        this.fileResolver = fileResolver;
    }

    public DefaultSourceDirectorySet(String name, FileResolver fileResolver) {
        this(name, name, fileResolver);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<File> getSrcDirs() {
        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
        for (DirectoryTree tree : this.getSrcDirTrees()) {
            dirs.add(tree.getDir());
        }
        return dirs;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    @Override
    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    @Override
    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.patterns.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.patterns.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public PatternFilterable include(String ... includes) {
        this.patterns.include(includes);
        return this;
    }

    @Override
    public PatternFilterable include(Iterable<String> includes) {
        this.patterns.include((Iterable)includes);
        return this;
    }

    @Override
    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.patterns.include((Spec)includeSpec);
        return this;
    }

    @Override
    public PatternFilterable include(Closure includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Iterable<String> excludes) {
        this.patterns.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(String ... excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    @Override
    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.patterns.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable exclude(Closure excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    @Override
    public Set<DirectoryTree> getSrcDirTrees() {
        LinkedHashMap<File, DirectoryTree> trees = new LinkedHashMap<File, DirectoryTree>();
        for (DirectoryTree tree : this.doGetSrcDirTrees()) {
            if (trees.containsKey(tree.getDir())) continue;
            trees.put(tree.getDir(), tree);
        }
        return new LinkedHashSet<DirectoryTree>(trees.values());
    }

    private Set<DirectoryTree> doGetSrcDirTrees() {
        LinkedHashSet<DirectoryTree> result = new LinkedHashSet<DirectoryTree>();
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                SourceDirectorySet nested = (SourceDirectorySet)path;
                result.addAll(nested.getSrcDirTrees());
                continue;
            }
            File srcDir = this.fileResolver.resolve(path);
            if (srcDir.exists() && !srcDir.isDirectory()) {
                throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", srcDir));
            }
            result.add(new DirectoryFileTree(srcDir, this.patterns));
        }
        return result;
    }

    @Override
    public void resolve(FileCollectionResolveContext context) {
        for (DirectoryTree directoryTree : this.getSrcDirTrees()) {
            if (!directoryTree.getDir().isDirectory()) continue;
            context.add(((DirectoryFileTree)directoryTree).filter(this.filter));
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    public SourceDirectorySet srcDirs(Object ... srcDirs) {
        for (Object srcDir : srcDirs) {
            this.source.add(srcDir);
        }
        return this;
    }

    @Override
    public SourceDirectorySet setSrcDirs(Iterable<?> srcPaths) {
        this.source.clear();
        GUtil.addToCollection(this.source, srcPaths);
        return this;
    }

    @Override
    public SourceDirectorySet source(SourceDirectorySet source) {
        this.source.add(source);
        return this;
    }
}

