/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.uiDesigner.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;

public abstract class FormsBuilder
extends ModuleLevelBuilder {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.uiDesigner.compiler.FormsInstrumenter");
    protected static final Key<Map<File, Collection<File>>> FORMS_TO_COMPILE = Key.create((String)"_forms-to_compile_");
    protected static final String JAVA_EXTENSION = ".java";
    protected static final String FORM_EXTENSION = "form";
    protected static final String DOT_FORM_EXTENSION = ".form";
    protected static final FileFilter JAVA_SOURCES_FILTER = SystemInfo.isFileSystemCaseSensitive ? new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getPath().endsWith(FormsBuilder.JAVA_EXTENSION);
        }
    } : new FileFilter(){

        @Override
        public boolean accept(File file) {
            return StringUtil.endsWithIgnoreCase((String)file.getPath(), (String)FormsBuilder.JAVA_EXTENSION);
        }
    };
    protected static final FileFilter FORM_SOURCES_FILTER = SystemInfo.isFileSystemCaseSensitive ? new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getPath().endsWith(FormsBuilder.DOT_FORM_EXTENSION);
        }
    } : new FileFilter(){

        @Override
        public boolean accept(File file) {
            return StringUtil.endsWithIgnoreCase((String)file.getPath(), (String)FormsBuilder.DOT_FORM_EXTENSION);
        }
    };
    private final String myBuilderName;

    public FormsBuilder(BuilderCategory category, String name) {
        super(category);
        this.myBuilderName = name;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myBuilderName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/uiDesigner/compiler/FormsBuilder", "getPresentableName"));
        }
        return string;
    }

    protected static void addBinding(File srcFile, File form, Map<File, Collection<File>> container) {
        Collection<File> forms = container.get(srcFile);
        if (forms == null) {
            forms = new ArrayList<File>();
            container.put(srcFile, forms);
        }
        forms.add(form);
    }
}

