/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.configuration.browser.MethodList;
import java.awt.Component;
import javax.swing.Icon;

public class MethodBrowser
extends BrowseModuleValueActionListener {
    private final TestNGConfigurationEditor editor;

    public MethodBrowser(Project project, TestNGConfigurationEditor editor) {
        super(project);
        this.editor = editor;
    }

    protected String showDialog() {
        String className = this.editor.getClassName();
        if (className.trim().length() == 0) {
            Messages.showMessageDialog((Component)this.getField(), (String)"Set class name first", (String)"Cannot Browse Methods", (Icon)Messages.getInformationIcon());
            return null;
        }
        PsiClass psiclass = this.editor.getModuleSelector().findClass(className);
        if (psiclass == null) {
            Messages.showMessageDialog((Component)this.getField(), (String)("Class " + className + " does not exist"), (String)"Cannot Browse Methods", (Icon)Messages.getInformationIcon());
            return null;
        }
        PsiMethod psimethod = MethodList.showDialog(psiclass, this.getField());
        return psimethod == null ? null : psimethod.getName();
    }
}

