/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.net.NetUtils;
import com.theoryinpractice.testng.configuration.SearchingForTestsTask;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGVersionChecker;
import com.theoryinpractice.testng.model.IDEARemoteTestRunnerClient;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGRemoteListener;
import com.theoryinpractice.testng.model.TestProxy;
import com.theoryinpractice.testng.model.TreeRootNode;
import com.theoryinpractice.testng.ui.TestNGConsoleView;
import com.theoryinpractice.testng.ui.TestNGResults;
import com.theoryinpractice.testng.ui.actions.RerunFailedTestsAction;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageTypes;
import org.jetbrains.annotations.NotNull;
import org.testng.RemoteTestNGStarter;
import org.testng.annotations.AfterClass;
import org.testng.remote.RemoteTestNG;
import org.testng.remote.strprotocol.SerializedMessageSender;

public class TestNGRunnableState
extends JavaCommandLineState {
    private static final Logger LOG = Logger.getInstance((String)"TestNG Runner");
    private static final String TESTNG_TEST_FRAMEWORK_NAME = "TestNG";
    private final TestNGConfiguration config;
    private final RunnerSettings runnerSettings;
    protected final IDEARemoteTestRunnerClient client;
    private int port;
    private String debugPort;
    private File myTempFile;
    private BackgroundableProcessIndicator mySearchForTestIndicator;
    private ServerSocket myServerSocket;

    public TestNGRunnableState(ExecutionEnvironment environment, TestNGConfiguration config) {
        super(environment);
        this.runnerSettings = environment.getRunnerSettings();
        this.config = config;
        this.client = new IDEARemoteTestRunnerClient();
        if (this.runnerSettings instanceof DebuggingRunnerData) {
            DebuggingRunnerData debuggingRunnerData = (DebuggingRunnerData)this.runnerSettings;
            this.debugPort = debuggingRunnerData.getDebugPort();
            if (this.debugPort.length() == 0) {
                try {
                    this.debugPort = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
                debuggingRunnerData.setDebugPort(this.debugPort);
            }
            debuggingRunnerData.setLocal(true);
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
        }
        boolean smRunner = Registry.is((String)"testng_sm_runner");
        if (smRunner) {
            ExecutionResult executionResult = this.startSMRunner(executor);
            if (executionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
            }
            return executionResult;
        }
        OSProcessHandler processHandler = this.startProcess();
        final TreeRootNode unboundOutputRoot = new TreeRootNode();
        final TestNGConsoleView console = new TestNGConsoleView(this.config, this.getEnvironment(), unboundOutputRoot, executor);
        console.initUI();
        unboundOutputRoot.setPrinter((Printer)console.getPrinter());
        Disposer.register((Disposable)console, (Disposable)unboundOutputRoot);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.config, (ProcessHandler)processHandler, this.runnerSettings);
        final SearchingForTestsTask task = this.createSearchingForTestsTask(this.myServerSocket, this.config, this.myTempFile);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private boolean myStarted = false;
            private int myInsertIndex = 0;

            public void processTerminated(ProcessEvent event) {
                unboundOutputRoot.flush();
                if (TestNGRunnableState.this.mySearchForTestIndicator != null && !TestNGRunnableState.this.mySearchForTestIndicator.isCanceled()) {
                    task.finish();
                }
            }

            public void startNotified(ProcessEvent event) {
                TestNGRemoteListener listener = new TestNGRemoteListener(console, unboundOutputRoot);
                if (TestNGRunnableState.this.config.isSaveOutputToFile()) {
                    unboundOutputRoot.setOutputFilePath(TestNGRunnableState.this.config.getOutputFilePath());
                }
                TestNGRunnableState.this.client.prepareListening(listener, TestNGRunnableState.this.config.getProject(), TestNGRunnableState.this.port);
                this.myStarted = true;
                TestNGRunnableState.this.mySearchForTestIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)TestNGRunnableState.this.mySearchForTestIndicator);
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                TestNGResults resultsView = console.getResultsView();
                if (resultsView != null) {
                    resultsView.finish(this.myStarted);
                }
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                TestProxy currentTest = console.getCurrentTest();
                final String text = event.getText();
                final ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                Printable printable = new Printable(){

                    public void printOn(Printer printer) {
                        printer.print(text, consoleViewType);
                    }
                };
                if (currentTest != null) {
                    currentTest.addLast(printable);
                } else {
                    unboundOutputRoot.insert(printable, this.myInsertIndex);
                }
                ++this.myInsertIndex;
            }
        });
        console.attachToProcess((ProcessHandler)processHandler);
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction((ComponentContainer)console, console.getProperties());
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return console.getResultsView();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        DefaultExecutionResult defaultExecutionResult = result;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "execute"));
        }
        return defaultExecutionResult;
    }

    private ExecutionResult startSMRunner(Executor executor) throws ExecutionException {
        this.getJavaParameters().getVMParametersList().add("-Didea.testng.sm_runner");
        this.getJavaParameters().getClassPath().add(PathUtil.getJarPathForClass(ServiceMessageTypes.class));
        OSProcessHandler handler = this.startProcess();
        SMTRunnerConsoleProperties testConsoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)this.config, TESTNG_TEST_FRAMEWORK_NAME, executor);
        testConsoleProperties.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        final BaseTestsOutputConsoleView smtConsoleView = SMTestRunnerConnectionUtil.createConsoleWithCustomLocator((String)TESTNG_TEST_FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties, (ExecutionEnvironment)this.getEnvironment(), null);
        Disposer.register((Disposable)this.getEnvironment().getProject(), (Disposable)smtConsoleView);
        smtConsoleView.attachToProcess((ProcessHandler)handler);
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction((ComponentContainer)smtConsoleView, (TestConsoleProperties)testConsoleProperties);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return ((SMTRunnerConsoleView)smtConsoleView).getResultsViewer();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)smtConsoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.config, (ProcessHandler)handler, this.runnerSettings);
        final SearchingForTestsTask task = this.createSearchingForTestsTask(this.myServerSocket, this.config, this.myTempFile);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                if (TestNGRunnableState.this.mySearchForTestIndicator != null && !TestNGRunnableState.this.mySearchForTestIndicator.isCanceled()) {
                    task.finish();
                }
            }

            public void startNotified(ProcessEvent event) {
                TestNGRunnableState.this.mySearchForTestIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)TestNGRunnableState.this.mySearchForTestIndicator);
            }
        });
        return result;
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        Object[] patchers;
        Project project = this.config.getProject();
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setupEnvs(this.config.getPersistantData().getEnvs(), this.config.getPersistantData().PASS_PARENT_ENVS);
        javaParameters.setMainClass("org.testng.RemoteTestNGStarter");
        javaParameters.setWorkingDirectory(this.config.getWorkingDirectory());
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(RemoteTestNGStarter.class));
        Module module = ((JavaRunConfigurationModule)this.config.getConfigurationModule()).getModule();
        LanguageLevel effectiveLanguageLevel = module == null ? LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel() : EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
        boolean is15 = effectiveLanguageLevel != LanguageLevel.JDK_1_4 && effectiveLanguageLevel != LanguageLevel.JDK_1_3;
        LOG.info("Language level is " + effectiveLanguageLevel.toString());
        LOG.info("is15 is " + is15);
        String pathToBundledJar = PathUtil.getJarPathForClass(AfterClass.class);
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)javaParameters, (CommonJavaRunConfigurationParameters)this.config);
        Sdk jdk = module == null ? ProjectRootManager.getInstance((Project)project).getProjectSdk() : ModuleRootManager.getInstance((Module)module).getSdk();
        javaParameters.setJdk(jdk);
        for (Object patcher : patchers = Extensions.getExtensions((String)"com.intellij.junitPatcher")) {
            ((JUnitPatcher)patcher).patchJavaParameters(module, javaParameters);
        }
        JavaSdkUtil.addRtJar((PathsList)javaParameters.getClassPath());
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
            ext.updateJavaParameters((RunConfigurationBase)this.config, javaParameters, this.getRunnerSettings());
        }
        LOG.info("Test scope is: " + this.config.getPersistantData().getScope());
        if (this.config.getPersistantData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            LOG.info("Configuring for whole project");
            JavaParametersUtil.configureProject((Project)this.config.getProject(), (JavaParameters)javaParameters, (int)7, this.config.ALTERNATIVE_JRE_PATH_ENABLED ? this.config.ALTERNATIVE_JRE_PATH : null);
        } else {
            LOG.info("Configuring for module:" + ((JavaRunConfigurationModule)this.config.getConfigurationModule()).getModuleName());
            JavaParametersUtil.configureModule((RunConfigurationModule)this.config.getConfigurationModule(), (JavaParameters)javaParameters, (int)7, this.config.ALTERNATIVE_JRE_PATH_ENABLED ? this.config.ALTERNATIVE_JRE_PATH : null);
        }
        javaParameters.getClassPath().add(pathToBundledJar);
        try {
            this.port = NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new ExecutionException("Unable to bind to port " + this.port, (Throwable)e);
        }
        TestData data = this.config.getPersistantData();
        javaParameters.getProgramParametersList().add(TestNGRunnableState.supportSerializationProtocol(this.config) ? "-serport" : "-port", String.valueOf(this.port));
        if (data.getOutputDirectory() != null && !data.getOutputDirectory().isEmpty()) {
            javaParameters.getProgramParametersList().add("-d", data.getOutputDirectory());
        }
        javaParameters.getProgramParametersList().add("-usedefaultlisteners", String.valueOf(data.USE_DEFAULT_REPORTERS));
        StringBuilder buf = new StringBuilder();
        if (data.TEST_LISTENERS != null && !data.TEST_LISTENERS.isEmpty()) {
            buf.append(StringUtil.join(data.TEST_LISTENERS, (String)";"));
        }
        for (Object o : Extensions.getExtensions((String)"com.theoryinpractice.testng.listener")) {
            boolean enabled = true;
            for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                if (!extension.isListenerDisabled((RunConfigurationBase)this.config, o, this.getRunnerSettings())) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(o.getClass().getName());
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass(o.getClass()));
        }
        if (buf.length() > 0) {
            javaParameters.getProgramParametersList().add("-listener", buf.toString());
        }
        try {
            this.myServerSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            javaParameters.getProgramParametersList().add("-socket" + this.myServerSocket.getLocalPort());
            this.myTempFile = FileUtil.createTempFile((String)"idea_testng", (String)".tmp");
            this.myTempFile.deleteOnExit();
            javaParameters.getProgramParametersList().add("-temp", this.myTempFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (this.runnerSettings instanceof DebuggingRunnerData) {
            ParametersList params = javaParameters.getVMParametersList();
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ignored) {
                // empty catch block
            }
            params.add("-Xdebug");
            params.add("-Xrunjdwp:transport=dt_socket,address=" + hostname + ':' + this.debugPort + ",suspend=y,server=n");
        }
        return javaParameters;
    }

    protected SearchingForTestsTask createSearchingForTestsTask(ServerSocket serverSocket, TestNGConfiguration config, File tempFile) {
        return new SearchingForTestsTask(serverSocket, config, tempFile, this.client);
    }

    public static boolean supportSerializationProtocol(TestNGConfiguration config) {
        PsiClass[] starters;
        Project project = config.getProject();
        GlobalSearchScope scopeToDetermineTestngIn = config.getPersistantData().getScope() == TestSearchScope.WHOLE_PROJECT ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)((JavaRunConfigurationModule)config.getConfigurationModule()).getModule());
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = facade.findClass(SerializedMessageSender.class.getName(), scopeToDetermineTestngIn);
        if (aClass == null) {
            return false;
        }
        for (PsiClass starter : starters = facade.findClasses(RemoteTestNG.class.getName(), scopeToDetermineTestngIn)) {
            if (starter.findFieldByName("m_serPort", false) != null) continue;
            LOG.info("Multiple TestNG versions found");
            return false;
        }
        return Registry.is((String)"testng.serialized.protocol.enabled") && !TestNGVersionChecker.isVersionIncompatible(project, scopeToDetermineTestngIn);
    }
}

