/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundRuntimeException
extends RuntimeException {
    private final List<Throwable> myThrowables;

    public CompoundRuntimeException(@NotNull List<Throwable> throwables) {
        if (throwables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwables", "com/intellij/util/lang/CompoundRuntimeException", "<init>"));
        }
        super("Several Exceptions occurred", throwables.get(0));
        this.myThrowables = throwables;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        for (Throwable throwable : this.myThrowables) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        for (Throwable throwable : this.myThrowables) {
            throwable.printStackTrace(s);
        }
    }

    public static void doThrow(@Nullable List<Throwable> throwables) {
        if (ContainerUtil.isEmpty(throwables)) {
            return;
        }
        if (throwables.size() == 1) {
            Throwable throwable = throwables.get(0);
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        throw new CompoundRuntimeException(throwables);
    }
}

