/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtils;
import com.intellij.util.UnmodifiableIterator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FluentIterable;
import com.intellij.util.containers.SingletonIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class TreeTraverser<T> {
    public abstract Iterable<T> children(T var1);

    public final FluentIterable<T> preOrderTraversal(final @NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return TreeTraverser.this.preOrderIterator(root);
            }
        };
    }

    Iterator<T> preOrderIterator(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser", "preOrderIterator"));
        }
        return new PreOrderIterator(root);
    }

    public final FluentIterable<T> postOrderTraversal(final @NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return TreeTraverser.this.postOrderIterator(root);
            }
        };
    }

    Iterator<T> postOrderIterator(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser", "postOrderIterator"));
        }
        return new PostOrderIterator(root);
    }

    public final FluentIterable<T> breadthFirstTraversal(final @NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new BreadthFirstIterator(root);
            }
        };
    }

    private final class BreadthFirstIterator
    extends UnmodifiableIterator<T> {
        private final Deque<T> queue;

        BreadthFirstIterator(T root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser$BreadthFirstIterator", "<init>"));
            }
            super(null);
            this.queue = new ArrayDeque();
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        public T peek() {
            return this.queue.element();
        }

        @Override
        public T next() {
            Object result = this.queue.remove();
            ContainerUtil.addAll(this.queue, TreeTraverser.this.children(result));
            return result;
        }
    }

    private final class PostOrderIterator
    extends UnmodifiableIterator<T> {
        private final ArrayDeque<PostOrderNode<T>> stack;

        PostOrderIterator(T root) {
            super(null);
            this.stack = new ArrayDeque();
            this.stack.addLast(this.expand(root));
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            return this.computeNext();
        }

        private T computeNext() {
            while (!this.stack.isEmpty()) {
                PostOrderNode top = this.stack.getLast();
                if (top.childIterator.hasNext()) {
                    Object child = top.childIterator.next();
                    this.stack.addLast(this.expand(child));
                    continue;
                }
                this.stack.removeLast();
                return top.root;
            }
            return null;
        }

        private PostOrderNode<T> expand(T t) {
            return new PostOrderNode(t, TreeTraverser.this.children(t).iterator());
        }
    }

    private static final class PostOrderNode<T> {
        final T root;
        final Iterator<T> childIterator;

        PostOrderNode(@NotNull T root, @NotNull Iterator<T> childIterator) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser$PostOrderNode", "<init>"));
            }
            if (childIterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childIterator", "com/intellij/util/containers/TreeTraverser$PostOrderNode", "<init>"));
            }
            this.root = root;
            this.childIterator = childIterator;
        }
    }

    private final class PreOrderIterator
    extends UnmodifiableIterator<T> {
        private final Deque<Iterator<T>> stack;

        PreOrderIterator(T root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser$PreOrderIterator", "<init>"));
            }
            super(null);
            this.stack = new ArrayDeque();
            this.stack.addLast(new SingletonIterator(root));
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            Iterator childItr;
            Iterator itr = this.stack.getLast();
            Object result = ObjectUtils.assertNotNull(itr.next());
            if (!itr.hasNext()) {
                this.stack.removeLast();
            }
            if ((childItr = TreeTraverser.this.children(result).iterator()).hasNext()) {
                this.stack.addLast(childItr);
            }
            return result;
        }
    }
}

