/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SingletonIterator;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SingletonSet<E>
implements Set<E> {
    private final E theElement;
    @NotNull
    private final TObjectHashingStrategy<E> strategy;

    public SingletonSet(E e) {
        this(e, ContainerUtil.canonicalStrategy());
    }

    public SingletonSet(E e, @NotNull TObjectHashingStrategy<E> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/SingletonSet", "<init>"));
        }
        this.theElement = e;
        this.strategy = strategy;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object elem) {
        return this.strategy.equals(this.theElement, elem);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        SingletonIterator<E> singletonIterator = new SingletonIterator<E>(this.theElement);
        if (singletonIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SingletonSet", "iterator"));
        }
        return singletonIterator;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = new Object[]{this.theElement};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SingletonSet", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/SingletonSet", "toArray"));
        }
        if (a.length == 0) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
        }
        a[0] = this.theElement;
        if (a.length > 1) {
            a[1] = null;
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SingletonSet", "toArray"));
        }
        return a;
    }

    @Override
    public boolean add(E t) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/SingletonSet", "containsAll"));
        }
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/SingletonSet", "addAll"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/SingletonSet", "retainAll"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/SingletonSet", "removeAll"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void clear() {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

