/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    private final List<RegistryValueListener> myListeners;
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;

    RegistryValue(@NotNull Registry registry, @NotNull String key) {
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/openapi/util/registry/RegistryValue", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/RegistryValue", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRegistry = registry;
        this.myKey = key;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/RegistryValue", "getKey"));
        }
        return string;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/RegistryValue", "asString"));
        }
        return string;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
        }
        return this.myIntCachedValue;
    }

    public double asDouble() {
        if (this.myDoubleCachedValue == null) {
            this.myDoubleCachedValue = Double.valueOf(this.get(this.myKey, "0.0", true));
        }
        return this.myDoubleCachedValue;
    }

    public Color asColor(Color defaultValue) {
        String[] rgb;
        String s = this.get(this.myKey, null, true);
        if (s != null && (rgb = s.split(",")).length == 3) {
            try {
                return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        String string = this.get(this.myKey + ".description", "", false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/RegistryValue", "getDescription"));
        }
        return string;
    }

    public boolean isRestartRequired() {
        return Boolean.valueOf(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString());
    }

    boolean isChangedFromDefault(@NotNull String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/openapi/util/registry/RegistryValue", "isChangedFromDefault"));
        }
        return !newValue.equals(RegistryValue.getBundleValue(this.myKey, false));
    }

    private String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/RegistryValue", "get"));
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, isValue);
                if (this.isBoolean()) {
                    this.myStringCachedValue = Boolean.valueOf(this.myStringCachedValue).toString();
                }
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, isValue);
    }

    private String _get(@NotNull String key, String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/RegistryValue", "_get"));
        }
        String userValue = this.myRegistry.getUserProperties().get(key);
        if (userValue != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        String bundleValue = RegistryValue.getBundleValue(key, mustExistInBundle);
        if (bundleValue != null) {
            return bundleValue;
        }
        return defaultValue;
    }

    private static String getBundleValue(@NotNull String key, boolean mustExist) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/RegistryValue", "getBundleValue"));
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.valueOf(value).toString());
    }

    public void setValue(int value) {
        this.setValue(Integer.valueOf(value).toString());
    }

    public void setValue(String value) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
    }

    public boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        this.setValue(RegistryValue.getBundleValue(this.myKey, true));
    }

    public void addListener(final @NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/util/registry/RegistryValue", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/registry/RegistryValue", "addListener"));
        }
        this.myListeners.add(listener);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.myListeners.remove(listener);
            }
        });
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return "true".equals(this.asString()) || "false".equals(this.asString());
    }
}

