/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.PrivateKeyReader;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

public class SslSocketFactory
extends SSLSocketFactory {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    private SSLSocketFactory myFactory;

    public SslSocketFactory() throws GeneralSecurityException, IOException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            KeyManager[] keyManagerArray;
            TrustManager[] trustManagerArray;
            String caCertPath = System.getProperty(SSL_CA_CERT_PATH);
            String clientCertPath = System.getProperty(SSL_CLIENT_CERT_PATH);
            String clientKeyPath = System.getProperty(SSL_CLIENT_KEY_PATH);
            boolean trustEverybody = StringUtilRt.parseBoolean(System.getProperty(SSL_TRUST_EVERYBODY), false);
            if (trustEverybody) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new MyTrustEverybodyManager();
            } else if (caCertPath == null) {
                trustManagerArray = new TrustManager[]{};
            } else {
                TrustManager[] trustManagerArray3 = new TrustManager[1];
                trustManagerArray = trustManagerArray3;
                trustManagerArray3[0] = new MyTrustManager(caCertPath);
            }
            tms = trustManagerArray;
            if (clientCertPath != null && clientKeyPath != null) {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new MyKeyManager(clientCertPath, clientKeyPath);
            } else {
                keyManagerArray = new KeyManager[]{};
            }
            kms = keyManagerArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(kms, tms, null);
        this.myFactory = ctx.getSocketFactory();
    }

    @Override
    @NotNull
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port, localHost, localPort);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.myFactory.createSocket(address, port, localAddress, localPort);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.myFactory.createSocket(socket, host, port, autoClose);
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.myFactory.getDefaultCipherSuites();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "getDefaultCipherSuites"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.myFactory.getSupportedCipherSuites();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "getSupportedCipherSuites"));
        }
        return stringArray;
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readCertificate"));
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream inStream = new FileInputStream(filePath);
        X509Certificate ca = (X509Certificate)factory.generateCertificate(inStream);
        ((InputStream)inStream).close();
        X509Certificate x509Certificate = ca;
        if (x509Certificate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readCertificate"));
        }
        return x509Certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readPrivateKey"));
        }
        PrivateKey privateKey = new PrivateKeyReader(filePath).getPrivateKey();
        if (privateKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readPrivateKey"));
        }
        return privateKey;
    }

    private static class MyKeyManager
    extends X509ExtendedKeyManager {
        private final String myAlias;
        private final X509Certificate[] myCertificates;
        private final PrivateKey myPrivateKey;

        private MyKeyManager(@NotNull String certPath, @NotNull String keyPath) throws Exception {
            if (certPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certPath", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "<init>"));
            }
            if (keyPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyPath", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "<init>"));
            }
            this.myAlias = UUID.randomUUID().toString();
            this.myCertificates = new X509Certificate[]{SslSocketFactory.readCertificate(certPath)};
            this.myPrivateKey = SslSocketFactory.readPrivateKey(keyPath);
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return new String[0];
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.myAlias;
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return new String[0];
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return this.myCertificates;
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.myPrivateKey;
        }
    }

    private static class MyTrustEverybodyManager
    implements X509TrustManager {
        private MyTrustEverybodyManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{};
            if (x509CertificateArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustEverybodyManager", "getAcceptedIssuers"));
            }
            return x509CertificateArray;
        }
    }

    private static class MyTrustManager
    implements X509TrustManager {
        @NotNull
        private final String myCaCertPath;
        private X509TrustManager trustManager;

        private MyTrustManager(@NotNull String caCertPath) throws Exception {
            if (caCertPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caCertPath", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "<init>"));
            }
            this.myCaCertPath = caCertPath;
            KeyStore ks = this.createStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @NotNull
        public KeyStore createStore() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            X509Certificate caCert = SslSocketFactory.readCertificate(this.myCaCertPath);
            ks.setCertificateEntry(UUID.randomUUID().toString(), caCert);
            KeyStore keyStore = ks;
            if (keyStore == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "createStore"));
            }
            return keyStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{};
            if (x509CertificateArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "getAcceptedIssuers"));
            }
            return x509CertificateArray;
        }
    }
}

