/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends ClassLoader
implements ClassLoaderHierarchy {
    private final List<ClassLoader> parents;
    private final JavaMethod<ClassLoader, Package[]> getPackagesMethod;
    private final JavaMethod<ClassLoader, Package> getPackageMethod;

    public MultiParentClassLoader(ClassLoader ... parents) {
        this(Arrays.asList(parents));
    }

    public MultiParentClassLoader(Collection<? extends ClassLoader> parents) {
        super(null);
        this.parents = new CopyOnWriteArrayList<ClassLoader>(parents);
        this.getPackagesMethod = JavaReflectionUtil.method(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
        this.getPackageMethod = JavaReflectionUtil.method(ClassLoader.class, Package.class, "getPackage", new Class[]{String.class});
    }

    public void addParent(ClassLoader parent) {
        this.parents.add(parent);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec());
        for (ClassLoader parent : this.parents) {
            visitor.visitParent(parent);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader parent : this.parents) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("%s not found.", name));
    }

    @Override
    protected Package getPackage(String name) {
        for (ClassLoader parent : this.parents) {
            Package p = this.getPackageMethod.invoke(parent, name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    protected Package[] getPackages() {
        LinkedHashSet<Package> packages = new LinkedHashSet<Package>();
        for (ClassLoader parent : this.parents) {
            Package[] parentPackages = this.getPackagesMethod.invoke(parent, new Object[0]);
            packages.addAll(Arrays.asList(parentPackages));
        }
        return packages.toArray(new Package[packages.size()]);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader parent : this.parents) {
            URL resource = parent.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        for (ClassLoader parent : this.parents) {
            Enumeration<URL> parentResources = parent.getResources(name);
            while (parentResources.hasMoreElements()) {
                resources.add(parentResources.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    public static class Spec
    extends ClassLoaderSpec {
        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(Spec.class);
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }
    }
}

