/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRepositoryImpl
extends BaseRepository {
    private final HttpClient myClient;

    protected BaseRepositoryImpl() {
        this.myClient = this.createClient();
    }

    protected BaseRepositoryImpl(TaskRepositoryType type) {
        super(type);
        this.myClient = this.createClient();
    }

    protected BaseRepositoryImpl(BaseRepositoryImpl other) {
        super(other);
        this.myClient = other.myClient;
    }

    protected static String encodeUrl(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/tasks/impl/BaseRepositoryImpl", "encodeUrl"));
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpClient getHttpClient() {
        return this.myClient;
    }

    private HttpClient createClient() {
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.configureHttpClient(client);
        ServiceManager.getService(CertificateManager.class);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void reconfigureClient() {
        HttpClient httpClient = this.myClient;
        synchronized (httpClient) {
            this.configureHttpClient(this.myClient);
        }
    }

    protected void configureHttpClient(HttpClient client) {
        client.getParams().setConnectionManagerTimeout(3000L);
        client.getParams().setSoTimeout(TaskSettings.getInstance().CONNECTION_TIMEOUT);
        if (this.isUseProxy()) {
            HttpConfigurable proxy = HttpConfigurable.getInstance();
            client.getHostConfiguration().setProxy(proxy.PROXY_HOST, proxy.PROXY_PORT);
            if (proxy.PROXY_AUTHENTICATION) {
                AuthScope authScope = new AuthScope(proxy.PROXY_HOST, proxy.PROXY_PORT);
                Credentials credentials = BaseRepositoryImpl.getCredentials(proxy.PROXY_LOGIN, proxy.getPlainProxyPassword(), proxy.PROXY_HOST);
                client.getState().setProxyCredentials(authScope, credentials);
            }
        }
        if (this.isUseHttpAuthentication()) {
            client.getParams().setCredentialCharset("UTF-8");
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
        } else {
            client.getState().clearCredentials();
            client.getParams().setAuthenticationPreemptive(false);
        }
    }

    @Nullable
    private static Credentials getCredentials(String login, String password, String host) {
        int domainIndex = login.indexOf("\\");
        if (domainIndex > 0) {
            String domain = login.substring(0, domainIndex);
            if (login.length() > domainIndex + 1) {
                String user = login.substring(domainIndex + 1);
                return new NTCredentials(user, password, host, domain);
            }
            return null;
        }
        return new UsernamePasswordCredentials(login, password);
    }

    protected void configureHttpMethod(HttpMethod method) {
    }

    @Override
    public void setUseProxy(boolean useProxy) {
        if (useProxy != this.isUseProxy()) {
            super.setUseProxy(useProxy);
            this.reconfigureClient();
        }
    }

    @Override
    public void setUseHttpAuthentication(boolean useHttpAuthentication) {
        if (useHttpAuthentication != this.isUseHttpAuthentication()) {
            super.setUseHttpAuthentication(useHttpAuthentication);
            this.reconfigureClient();
        }
    }

    @Override
    public void setPassword(String password) {
        if (!password.equals(this.getPassword())) {
            super.setPassword(password);
            this.reconfigureClient();
        }
    }

    @Override
    public void setUsername(String username) {
        if (!username.equals(this.getUsername())) {
            super.setUsername(username);
            this.reconfigureClient();
        }
    }

    public static abstract class HttpTestConnection<T extends HttpMethod>
    extends TaskRepository.CancellableConnection {
        protected T myMethod;

        public HttpTestConnection(T method) {
            this.myMethod = method;
        }

        @Override
        protected void doTest() throws Exception {
            this.doTest(this.myMethod);
        }

        @Override
        public void cancel() {
            this.myMethod.abort();
        }

        protected abstract void doTest(T var1) throws Exception;
    }
}

