/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;

public class OpenBitSetDISI
extends OpenBitSet {
    static final /* synthetic */ boolean $assertionsDisabled;

    public OpenBitSetDISI(DocIdSetIterator disi, int maxSize) throws IOException {
        super(maxSize);
        this.inPlaceOr(disi);
    }

    public OpenBitSetDISI(int maxSize) {
        super(maxSize);
    }

    public void inPlaceOr(DocIdSetIterator disi) throws IOException {
        while (disi.next() && (long)disi.doc() < this.size()) {
            this.fastSet(disi.doc());
        }
    }

    public void inPlaceAnd(DocIdSetIterator disi) throws IOException {
        int index = this.nextSetBit(0);
        int lastNotCleared = -1;
        while (index != -1 && disi.skipTo(index)) {
            while (index != -1 && index < disi.doc()) {
                this.fastClear(index);
                index = this.nextSetBit(index + 1);
            }
            if (index == disi.doc()) {
                lastNotCleared = index++;
            }
            if (!$assertionsDisabled && index != -1 && index <= disi.doc()) {
                throw new AssertionError();
            }
        }
        this.clear(lastNotCleared + 1, this.size());
    }

    public void inPlaceNot(DocIdSetIterator disi) throws IOException {
        while (disi.next() && (long)disi.doc() < this.size()) {
            this.fastClear(disi.doc());
        }
    }

    public void inPlaceXor(DocIdSetIterator disi) throws IOException {
        while (disi.next() && (long)disi.doc() < this.size()) {
            this.fastFlip(disi.doc());
        }
    }

    static {
        $assertionsDisabled = !OpenBitSetDISI.class.desiredAssertionStatus();
    }
}

