/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.google.common.collect.Sets;
import com.intellij.execution.RunManagerEx;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManagerState;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

@State(name="MavenCompilerTasksManager", storages={@Storage(file="$PROJECT_FILE$")})
public class MavenTasksManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenTasksManagerState> {
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private MavenTasksManagerState myState = new MavenTasksManagerState();
    private final MavenProjectsManager myProjectsManager;
    private final MavenRunner myRunner;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static MavenTasksManager getInstance(Project project) {
        return (MavenTasksManager)((Object)project.getComponent(MavenTasksManager.class));
    }

    public MavenTasksManager(Project project, MavenProjectsManager projectsManager, MavenRunner runner) {
        super(project);
        this.myProjectsManager = projectsManager;
        this.myRunner = runner;
    }

    public synchronized MavenTasksManagerState getState() {
        MavenTasksManagerState result = new MavenTasksManagerState();
        result.afterCompileTasks = new THashSet(this.myState.afterCompileTasks);
        result.beforeCompileTasks = new THashSet(this.myState.beforeCompileTasks);
        result.afterRebuildTask = new THashSet(this.myState.afterRebuildTask);
        result.beforeRebuildTask = new THashSet(this.myState.beforeRebuildTask);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(MavenTasksManagerState state) {
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState = state;
        }
        if (this.isInitialized.get()) {
            this.fireTasksChanged();
        }
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        class MyCompileTask
        implements CompileTask {
            private final boolean myBefore;

            MyCompileTask(boolean before) {
                this.myBefore = before;
            }

            public boolean execute(CompileContext context) {
                return MavenTasksManager.this.doExecute(this.myBefore, context);
            }
        }
        compilerManager.addBeforeTask((CompileTask)new MyCompileTask(true));
        compilerManager.addAfterTask((CompileTask)new MyCompileTask(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(boolean before, CompileContext context) {
        ArrayList<MavenRunnerParameters> parametersList;
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            Sets.SetView tasks;
            parametersList = new ArrayList<MavenRunnerParameters>();
            Object object = tasks = before ? this.myState.beforeCompileTasks : this.myState.afterCompileTasks;
            if (context.isRebuild()) {
                tasks = Sets.union(before ? this.myState.beforeRebuildTask : this.myState.afterRebuildTask, tasks);
            }
            for (MavenCompilerTask each : tasks) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each.getProjectPath());
                if (file == null) continue;
                MavenExplicitProfiles explicitProfiles = this.myProjectsManager.getExplicitProfiles();
                parametersList.add(new MavenRunnerParameters(true, file.getParent().getPath(), Arrays.asList(each.getGoal()), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles()));
            }
        }
        return this.myRunner.runBatch(parametersList, null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), context.getProgressIndicator());
    }

    public synchronized boolean isCompileTaskOfPhase(@NotNull MavenCompilerTask task, @NotNull Phase phase) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/tasks/MavenTasksManager", "isCompileTaskOfPhase"));
        }
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "org/jetbrains/idea/maven/tasks/MavenTasksManager", "isCompileTaskOfPhase"));
        }
        return this.myState.getTasks(phase).contains(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "org/jetbrains/idea/maven/tasks/MavenTasksManager", "addCompileTasks"));
        }
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.getTasks(phase).addAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileTasks(List<MavenCompilerTask> tasks, @NotNull Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "org/jetbrains/idea/maven/tasks/MavenTasksManager", "removeCompileTasks"));
        }
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            this.myState.getTasks(phase).removeAll(tasks);
        }
        this.fireTasksChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(MavenProject project, String goal) {
        ArrayList<String> result = new ArrayList<String>();
        MavenCompilerTask compilerTask = new MavenCompilerTask(project.getPath(), goal);
        MavenTasksManager mavenTasksManager = this;
        synchronized (mavenTasksManager) {
            for (Phase phase : Phase.values()) {
                if (!this.myState.getTasks(phase).contains(compilerTask)) continue;
                result.add(TasksBundle.message(phase.myMessageKey, new Object[0]));
            }
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        for (MavenBeforeRunTask each : runManager.getBeforeRunTasks(MavenBeforeRunTasksProvider.ID)) {
            if (!each.isFor(project, goal)) continue;
            result.add(TasksBundle.message("maven.tasks.goal.before.run", new Object[0]));
            break;
        }
        return StringUtil.join(result, (String)", ");
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.compileTasksChanged();
        }
    }

    public static interface Listener {
        public void compileTasksChanged();
    }

    public static enum Phase {
        BEFORE_COMPILE("maven.tasks.goal.before.compile"),
        AFTER_COMPILE("maven.tasks.goal.after.compile"),
        BEFORE_REBUILD("maven.tasks.goal.before.rebuild"),
        AFTER_REBUILD("maven.tasks.goal.after.rebuild");

        public final String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }
    }
}

